/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.render;

import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.render.RenderPolicy;

public class DefaultRenderPolicy
extends RenderPolicy {
    private int pendingRepaints;

    public DefaultRenderPolicy(Desktop desktop) {
        super(desktop);
    }

    @Override
    public void renderDesktop() {
        Desktop desktop = this.getDesktop();
        Widget widget = desktop.getWidget();
        if (widget != null) {
            GraphicsContext g = Display.getDisplay().getGraphicsContext();
            g.resetTranslation();
            g.resetClip();
            desktop.renderWidget(g, widget);
        }
    }

    @Override
    public void requestRender(Widget widget, int x, int y, int width, int height) {
        while (widget.isTransparent()) {
            Container parent = widget.getParent();
            if (parent == null) break;
            x += parent.getContentX() + widget.getX();
            y += parent.getContentY() + widget.getY();
            widget = parent;
        }
        this.asynchronousRender(widget, x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynchronousRender(final Widget widget, final int x, final int y, final int width, final int height) {
        MicroUI.callSerially((Runnable)new Runnable(){

            @Override
            public void run() {
                DefaultRenderPolicy.this.executeRender(widget, x, y, width, height);
            }
        });
        DefaultRenderPolicy defaultRenderPolicy = this;
        synchronized (defaultRenderPolicy) {
            ++this.pendingRepaints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRender(Widget widget, int x, int y, int width, int height) {
        int pendingRepaints;
        if (!widget.isAttached()) {
            DefaultRenderPolicy defaultRenderPolicy = this;
            synchronized (defaultRenderPolicy) {
                --this.pendingRepaints;
            }
            return;
        }
        try {
            this.renderWidget(widget, x, y, width, height);
        }
        catch (Throwable throwable) {
            int pendingRepaints2;
            DefaultRenderPolicy defaultRenderPolicy = this;
            synchronized (defaultRenderPolicy) {
                pendingRepaints2 = --this.pendingRepaints;
            }
            Display display = Display.getDisplay();
            if (pendingRepaints2 == 0) {
                display.flush();
            } else {
                display.requestFlush();
            }
            throw throwable;
        }
        DefaultRenderPolicy display = this;
        synchronized (display) {
            pendingRepaints = --this.pendingRepaints;
        }
        display = Display.getDisplay();
        if (pendingRepaints == 0) {
            display.flush();
        } else {
            display.requestFlush();
        }
    }

    protected void renderWidget(Widget widget, int x, int y, int width, int height) {
        GraphicsContext g = Display.getDisplay().getGraphicsContext();
        g.resetTranslation();
        g.resetClip();
        this.setParentClip(widget, g);
        g.intersectClip(widget.getX() + x, widget.getY() + y, width, height);
        this.getDesktop().renderWidget(g, widget);
    }

    protected void setParentClip(Widget widget, GraphicsContext g) {
        Container parent = widget.getParent();
        if (parent != null) {
            this.setParentClip(parent, g);
            g.translate(parent.getX() + parent.getContentX(), parent.getY() + parent.getContentY());
            g.intersectClip(0, 0, parent.getContentWidth(), parent.getContentHeight());
        }
    }
}

