/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;

public class ConnectivityManager {
    @Nullable
    private NetworkMapping defaultNetwork = null;
    private NetworkMapping[] networkMappings = new NetworkMapping[0];
    private RequestMapping[] requests = new RequestMapping[0];
    private NetworkCallback[] defaultCallbacks = new NetworkCallback[0];
    private final Object requestMutex = new Object();

    protected ConnectivityManager() {
    }

    @Nullable
    public NetworkInfo getActiveNetworkInfo() {
        NetworkMapping defaultNetwork = this.defaultNetwork;
        return defaultNetwork == null ? null : defaultNetwork.networkInfo;
    }

    @Nullable
    public Network getActiveNetwork() {
        NetworkMapping defaultNetwork = this.defaultNetwork;
        return defaultNetwork == null ? null : defaultNetwork.network;
    }

    public Network[] getAllNetworks() {
        Object[] networks = new Network[]{};
        NetworkMapping[] networkMappingArray = this.networkMappings;
        int n = this.networkMappings.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkMapping networkMapping = networkMappingArray[n2];
            networks = (Network[])ArrayTools.add((Object[])networks, (Object)networkMapping.network);
            ++n2;
        }
        return networks;
    }

    @Nullable
    public NetworkCapabilities getNetworkCapabilities(Network network) {
        NetworkMapping mapping = this.getMapping(network);
        return mapping != null ? mapping.capabilities : null;
    }

    @Nullable
    public NetworkInfo getNetworkInfo(Network network) {
        NetworkMapping mapping = this.getMapping(network);
        return mapping != null ? mapping.networkInfo : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultNetworkCallback(NetworkCallback networkCallback) {
        Object object = this.requestMutex;
        synchronized (object) {
            if (ArrayTools.contains((Object[])this.defaultCallbacks, (Object)networkCallback)) {
                return;
            }
            this.defaultCallbacks = (NetworkCallback[])ArrayTools.add((Object[])this.defaultCallbacks, (Object)networkCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetworkCallback(@Nullable NetworkRequest request, NetworkCallback networkCallback) {
        RequestMapping requestMapping = new RequestMapping(request, networkCallback);
        Object object = this.requestMutex;
        synchronized (object) {
            if (networkCallback != null && !ArrayTools.contains((Object[])this.requests, (Object)requestMapping)) {
                this.requests = (RequestMapping[])ArrayTools.add((Object[])this.requests, (Object)requestMapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNetworkCallback(NetworkCallback networkCallback) {
        if (networkCallback == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.requestMutex;
        synchronized (object) {
            this.defaultCallbacks = (NetworkCallback[])ArrayTools.remove((Object[])this.defaultCallbacks, (Object)networkCallback);
            Object[] strippedRequest = this.requests;
            RequestMapping[] requestMappingArray = this.requests;
            int n = this.requests.length;
            int n2 = 0;
            while (n2 < n) {
                RequestMapping requestMapping = requestMappingArray[n2];
                if (requestMapping.networkCallback.equals(networkCallback)) {
                    strippedRequest = (RequestMapping[])ArrayTools.remove((Object[])strippedRequest, (Object)requestMapping);
                }
                ++n2;
            }
            this.requests = strippedRequest;
        }
    }

    protected void setActiveNetwork(Network network) {
        boolean isNew;
        NetworkMapping mapping = this.getMapping(network);
        boolean bl = isNew = mapping == null;
        if (isNew) {
            mapping = this.newMapping(network, false, new NetworkCapabilities());
        }
        assert (mapping != null);
        NetworkMapping previousDefault = this.defaultNetwork;
        if (!mapping.equals(previousDefault)) {
            this.defaultNetwork = mapping;
            if (previousDefault != null) {
                Network previousNetwork = previousDefault.network;
                if (previousDefault.capabilities.hasCapability(12)) {
                    this.setCapabilities(previousDefault, new NetworkCapabilities());
                    this.doNotifyCapabilitiesChange(previousNetwork, previousDefault.capabilities, this.defaultCallbacks);
                }
                if (previousDefault.networkInfo.isConnected()) {
                    this.setAvailable(false, previousNetwork, previousDefault.networkInfo);
                    this.doNotifyAvailabilityChange(previousNetwork, false, this.defaultCallbacks);
                }
            }
            if (!isNew) {
                this.doNotifyAvailabilityChange(network, mapping.networkInfo.isConnected(), this.defaultCallbacks);
                this.doNotifyCapabilitiesChange(mapping.network, mapping.capabilities, this.defaultCallbacks);
            }
        }
    }

    @Deprecated
    protected void notifyNetworkCallbacks(boolean available) {
        this.notifyNetworkCallbacks(Network.NULL_NETWORK, available);
    }

    protected void notifyNetworkCallbacks(Network network, boolean available) {
        boolean isNew;
        NetworkMapping mapping = this.getMapping(network);
        boolean bl = isNew = mapping == null;
        if (isNew) {
            mapping = this.newMapping(network, available, new NetworkCapabilities());
        }
        assert (mapping != null);
        this.setAvailable(available, mapping.network, mapping.networkInfo);
        if (mapping == this.defaultNetwork) {
            this.doNotifyAvailabilityChange(mapping.network, available, this.defaultCallbacks);
        }
        this.doNotifyAvailabilityChange(mapping.network, available, this.getNetworkCallBacks(mapping.capabilities, mapping.capabilities));
    }

    protected void notifyNetworkCallbacks(Network network, NetworkCapabilities capabilities) {
        boolean isNew;
        NetworkMapping mapping = this.getMapping(network);
        boolean bl = isNew = mapping == null;
        if (isNew) {
            mapping = this.newMapping(network, false, capabilities);
        }
        assert (mapping != null);
        NetworkCapabilities oldCapabilities = new NetworkCapabilities();
        oldCapabilities.setCapabilities(mapping.capabilities.getCapabilities());
        this.setCapabilities(mapping, capabilities);
        if (mapping == this.defaultNetwork) {
            this.doNotifyCapabilitiesChange(mapping.network, capabilities, this.defaultCallbacks);
        }
        this.doNotifyCapabilitiesChange(mapping.network, capabilities, this.getNetworkCallBacks(oldCapabilities, capabilities));
    }

    private void setCapabilities(NetworkMapping mapping, NetworkCapabilities targetCapabilities) {
        mapping.capabilities.setCapabilities(targetCapabilities.getCapabilities());
    }

    protected void setAvailable(boolean available, @Nullable Network network, NetworkInfo networkInfo) {
        networkInfo.setConnected(available);
    }

    protected void doNotifyCapabilitiesChange(Network network, NetworkCapabilities capabilities, NetworkCallback[] networkCallBacks) {
        NetworkCallback[] networkCallbackArray = networkCallBacks;
        int n = networkCallBacks.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkCallback networkCallback = networkCallbackArray[n2];
            try {
                networkCallback.onCapabilitiesChanged(network, capabilities);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    protected void doNotifyAvailabilityChange(Network network, boolean available, NetworkCallback[] networkCallbacks) {
        if (available) {
            NetworkCallback[] networkCallbackArray = networkCallbacks;
            int n = networkCallbacks.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkCallback networkCallback = networkCallbackArray[n2];
                try {
                    networkCallback.onAvailable(network);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        } else {
            NetworkCallback[] networkCallbackArray = networkCallbacks;
            int n = networkCallbacks.length;
            int n3 = 0;
            while (n3 < n) {
                NetworkCallback networkCallback = networkCallbackArray[n3];
                try {
                    networkCallback.onLost(network);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n3;
            }
        }
    }

    private NetworkMapping newMapping(Network network, boolean available, NetworkCapabilities capabilities) {
        NetworkMapping mapping = new NetworkMapping(network);
        mapping.networkInfo.setConnected(available);
        mapping.capabilities.setCapabilities(capabilities.getCapabilities());
        this.networkMappings = (NetworkMapping[])ArrayTools.add((Object[])this.networkMappings, (Object)mapping);
        return mapping;
    }

    private NetworkCallback[] getNetworkCallBacks(NetworkCapabilities oldCapabilities, NetworkCapabilities capabilities) {
        Object[] callBacks = new NetworkCallback[]{};
        RequestMapping[] requestMappingArray = this.requests;
        int n = this.requests.length;
        int n2 = 0;
        while (n2 < n) {
            RequestMapping requestMapping = requestMappingArray[n2];
            if (requestMapping.fullfill(capabilities) || requestMapping.fullfill(oldCapabilities)) {
                callBacks = (NetworkCallback[])ArrayTools.add((Object[])callBacks, (Object)requestMapping.networkCallback);
            }
            ++n2;
        }
        return callBacks;
    }

    @Nullable
    private NetworkMapping getMapping(Network network) {
        NetworkMapping mapping = null;
        if (network != null) {
            NetworkMapping[] networkMappingArray = this.networkMappings;
            int n = this.networkMappings.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkMapping networkMapping = networkMappingArray[n2];
                if (network.equals(networkMapping.network)) {
                    mapping = networkMapping;
                }
                ++n2;
            }
        }
        return mapping;
    }

    public static class NetworkCallback {
        public void onAvailable(Network network) {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        }

        public void onLost(Network network) {
        }
    }

    private static class NetworkMapping {
        private final Network network;
        private final NetworkInfo networkInfo = new NetworkInfo();
        private final NetworkCapabilities capabilities = new NetworkCapabilities();

        public NetworkMapping(Network network) {
            this.network = network;
        }
    }

    private static class RequestMapping {
        @Nullable
        private final NetworkRequest request;
        private final NetworkCallback networkCallback;

        public RequestMapping(@Nullable NetworkRequest request, NetworkCallback networkCallbacks) {
            this.request = request;
            this.networkCallback = networkCallbacks;
        }

        public boolean fullfill(NetworkCapabilities capabilities) {
            boolean fullfill = true;
            if (this.request != null) {
                int[] nArray = this.request.networkCapabilities.getCapabilities();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int capability = nArray[n2];
                    if (!capabilities.hasCapability(capability)) {
                        fullfill = false;
                        break;
                    }
                    ++n2;
                }
            }
            return fullfill;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.networkCallback.hashCode();
            NetworkRequest req = this.request;
            if (req != null) {
                result = 31 * result + req.hashCode();
            }
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestMapping other = (RequestMapping)obj;
            if (!this.networkCallback.equals(other.networkCallback)) {
                return false;
            }
            if (this.request != null) {
                return this.request.equals(other.request);
            }
            return other.request == null;
        }
    }
}

