/*
 * Decompiled with CFR 0.152.
 */
package ej.restserver;

import ej.hoka.http.HTTPServer;
import ej.hoka.http.HTTPSession;
import ej.restserver.EndpointHandler;
import ej.restserver.RequestHandler;
import ej.restserver.RestEndpoint;
import ej.restserver.RestSession;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RestServer
extends HTTPServer {
    private final List<RestEndpoint> endpoints;
    private final List<RequestHandler> requestHandlers;

    public RestServer(int port, int maxSimultaneousConnection, int jobCountBySession) throws IOException {
        super(new ServerSocket(), maxSimultaneousConnection, jobCountBySession);
        ServerSocket currentConnection = this.getCurrentConnection();
        currentConnection.setReuseAddress(true);
        currentConnection.bind(new InetSocketAddress(port));
        this.endpoints = new LinkedList<RestEndpoint>();
        this.requestHandlers = new LinkedList<RequestHandler>();
        this.requestHandlers.add(new EndpointHandler());
    }

    public void addEndpoint(RestEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void addRequestResolver(RequestHandler handler) {
        this.requestHandlers.add(handler);
    }

    public List<RestEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public List<RequestHandler> getRequestResolvers() {
        return Collections.unmodifiableList(this.requestHandlers);
    }

    protected HTTPSession newHTTPSession() {
        return new RestSession(this);
    }
}

