/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.body.MultiPartBodyParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class HttpPart
extends InputStream {
    private static final String APPOSTROPHE = "\"";
    private static final String VALUE_ESCAPE = ";\r";
    private static final String KEY_ESCAPE = ":=";
    private static final String ESCAPE = "\n\r\n";
    private final Map<String, String> headers;
    private final MultiPartBodyParser.MultiPartBuffer multiPart;
    private boolean isFinished;
    private boolean headerParsed;
    private boolean isInit;

    HttpPart(MultiPartBodyParser.MultiPartBuffer multiPart) {
        this.multiPart = multiPart;
        this.isInit = false;
        this.isFinished = false;
        this.headers = new HashMap<String, String>();
        this.headerParsed = false;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    synchronized Map<String, String> parseHeaders() throws IOException {
        if (!this.headerParsed) {
            this.init();
            this.headerParsed = true;
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            boolean isKey = true;
            int escapePos = 0;
            int doRead = 0;
            while (escapePos < ESCAPE.length() && this.multiPart.hasData()) {
                doRead = this.multiPart.read();
                if (doRead == ESCAPE.charAt(escapePos)) {
                    ++escapePos;
                    continue;
                }
                escapePos = 0;
                if (isKey) {
                    if (KEY_ESCAPE.indexOf(doRead) != -1) {
                        isKey = false;
                        continue;
                    }
                    key.append((char)(doRead & 0xFF));
                    continue;
                }
                if (VALUE_ESCAPE.indexOf(doRead) != -1) {
                    isKey = true;
                    String valueString = value.toString().trim();
                    if (valueString.startsWith(APPOSTROPHE) && valueString.endsWith(APPOSTROPHE)) {
                        valueString = valueString.substring(1, valueString.length() - 1);
                    }
                    this.headers.put(key.toString().trim(), valueString.trim());
                    key = new StringBuilder();
                    value = new StringBuilder();
                    continue;
                }
                value.append((char)(doRead & 0xFF));
            }
        }
        return this.headers;
    }

    @Override
    public int read() throws IOException {
        int read = -1;
        if (!this.isFinished && this.multiPart.hasData()) {
            this.init();
            if (this.multiPart.getBoundaryIndex(1) == -1) {
                read = this.multiPart.read();
            } else {
                this.checkEnd();
            }
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = -1;
        if (!this.isFinished && this.multiPart.hasData()) {
            this.init();
            read = this.multiPart.read(b, off, len);
            if (read == -1) {
                this.checkEnd();
            }
        }
        return read;
    }

    private void checkEnd() {
        this.isFinished = true;
    }

    private synchronized void init() throws IOException {
        if (!this.isInit) {
            this.multiPart.skipToBoundary();
            this.isInit = true;
        }
    }
}

