/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZoneRegion;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Map;
import java.util.Set;

public abstract class ZoneId
implements Serializable {
    public static ZoneId systemDefault() {
        return ZoneId.of("GMT");
    }

    public static Set<String> getAvailableZoneIds() {
        return ZoneRulesProvider.getAvailableZoneIds();
    }

    public static ZoneId of(String zoneId, Map<String, String> aliasMap) {
        String id = aliasMap.get(zoneId);
        id = id != null ? id : zoneId;
        return ZoneId.of(id);
    }

    public static ZoneId of(String zoneId) {
        return ZoneId.of(zoneId, true);
    }

    public static ZoneId ofOffset(String prefix, ZoneOffset offset) {
        if (prefix.length() == 0) {
            return offset;
        }
        if (!(prefix.equals("GMT") || prefix.equals("UTC") || prefix.equals("UT"))) {
            throw new IllegalArgumentException("prefix should be GMT, UTC or UT, is: " + prefix);
        }
        if (offset.getTotalSeconds() != 0) {
            prefix = prefix.concat(offset.getId());
        }
        return new ZoneRegion(prefix, offset.getRules());
    }

    static ZoneId of(String zoneId, boolean checkAvailable) {
        if (zoneId.length() <= 1 || zoneId.startsWith("+") || zoneId.startsWith("-")) {
            return ZoneOffset.of(zoneId);
        }
        if (zoneId.startsWith("UTC") || zoneId.startsWith("GMT")) {
            return ZoneId.ofWithPrefix(zoneId, 3, checkAvailable);
        }
        if (zoneId.startsWith("UT")) {
            return ZoneId.ofWithPrefix(zoneId, 2, checkAvailable);
        }
        return ZoneRegion.ofId(zoneId, checkAvailable);
    }

    private static ZoneId ofWithPrefix(String zoneId, int prefixLength, boolean checkAvailable) {
        String prefix = zoneId.substring(0, prefixLength);
        if (zoneId.length() == prefixLength) {
            return ZoneId.ofOffset(prefix, ZoneOffset.UTC);
        }
        if (zoneId.charAt(prefixLength) != '+' && zoneId.charAt(prefixLength) != '-') {
            return ZoneRegion.ofId(zoneId, checkAvailable);
        }
        try {
            ZoneOffset offset = ZoneOffset.of(zoneId.substring(prefixLength));
            if (offset == ZoneOffset.UTC) {
                return ZoneId.ofOffset(prefix, offset);
            }
            return ZoneId.ofOffset(prefix, offset);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Invalid ID for offset-based ZoneId: " + zoneId, ex);
        }
    }

    public static ZoneId from(TemporalAccessor temporal) {
        ZoneId obj = temporal.query(TemporalQueries.zone());
        if (obj == null) {
            throw new DateTimeException("Unable to obtain ZoneId from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName());
        }
        return obj;
    }

    ZoneId() {
        if (this.getClass() != ZoneOffset.class && this.getClass() != ZoneRegion.class) {
            throw new AssertionError((Object)"Invalid subclass");
        }
    }

    public abstract String getId();

    public abstract ZoneRules getRules();

    public ZoneId normalized() {
        try {
            ZoneRules rules = this.getRules();
            if (rules.isFixedOffset()) {
                return rules.getOffset(Instant.EPOCH);
            }
        }
        catch (ZoneRulesException zoneRulesException) {}
        return this;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZoneId) {
            ZoneId other = (ZoneId)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

