/*
 * Decompiled with CFR 0.152.
 */
package ej.io.progress;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProgressInputStream
extends FilterInputStream {
    private final IProgressMonitor monitor;

    public ProgressInputStream(InputStream in, int totalBytes, IProgressMonitor monitor) {
        super(in);
        this.monitor = totalBytes > 0 ? SubMonitor.convert(monitor, totalBytes) : new NullProgressMonitor();
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read != -1) {
            this.progress(1);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.progress(read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.progress((int)skip);
        return skip;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void progress(int read) {
        if (read != -1) {
            this.monitor.worked(read);
        }
    }
}

