/*
 * Decompiled with CFR 0.152.
 */
package ej.microai;

import ej.microai.MLNatives;

public class Tensor {
    private final int modelHandle;
    private final int tensorIndex;
    private final boolean isInputTensor;

    Tensor(int modelHandle, int index, boolean isInputTensor) {
        this.modelHandle = modelHandle;
        this.tensorIndex = index;
        this.isInputTensor = isInputTensor;
    }

    public int getDataType() {
        int dataType = this.isInputTensor ? MLNatives.getInputDataType(this.modelHandle, this.tensorIndex) : MLNatives.getOutputDataType(this.modelHandle, this.tensorIndex);
        return dataType;
    }

    public int getNumberBytes() {
        int numberBytes = this.isInputTensor ? MLNatives.getInputNumBytes(this.modelHandle, this.tensorIndex) : MLNatives.getOutputNumBytes(this.modelHandle, this.tensorIndex);
        return numberBytes;
    }

    public int getNumberDimensions() {
        int numberDimensions = this.isInputTensor ? MLNatives.getInputNumDimensions(this.modelHandle, this.tensorIndex) : MLNatives.getOutputNumDimensions(this.modelHandle, this.tensorIndex);
        return numberDimensions;
    }

    public int getNumberElements() {
        int numberElements = this.isInputTensor ? MLNatives.getInputNumElements(this.modelHandle, this.tensorIndex) : MLNatives.getOutputNumElements(this.modelHandle, this.tensorIndex);
        return numberElements;
    }

    public QuantizationParameters getQuantizationParams() {
        float scale;
        int zeroPoint;
        if (this.isInputTensor) {
            zeroPoint = MLNatives.getInputZeroPoint(this.modelHandle, this.tensorIndex);
            scale = MLNatives.getInputScale(this.modelHandle, this.tensorIndex);
        } else {
            zeroPoint = MLNatives.getOutputZeroPoint(this.modelHandle, this.tensorIndex);
            scale = MLNatives.getOutputScale(this.modelHandle, this.tensorIndex);
        }
        return new QuantizationParameters(zeroPoint, scale);
    }

    public void getShape(int[] sizes) {
        if (this.isInputTensor) {
            MLNatives.getInputShape(this.modelHandle, this.tensorIndex, sizes);
        } else {
            MLNatives.getOutputShape(this.modelHandle, this.tensorIndex, sizes);
        }
    }

    public boolean isQuantized() {
        boolean isQuantized = this.isInputTensor ? MLNatives.inputQuantized(this.modelHandle, this.tensorIndex) : MLNatives.outputQuantized(this.modelHandle, this.tensorIndex);
        return isQuantized;
    }

    public static class DataType {
        public static final int UNKNOWN = 0;
        public static final int INT8 = 1;
        public static final int UINT8 = 2;
        public static final int FLOAT32 = 3;
        public static final int INT32 = 4;
        public static final int UINT32 = 5;

        private DataType() {
        }
    }

    public static class QuantizationParameters {
        private final float scale;
        private final int zeroPoint;

        public QuantizationParameters(int zeroPoint, float scale) {
            this.scale = scale;
            this.zeroPoint = zeroPoint;
        }

        public float getScale() {
            return this.scale;
        }

        public int getZeroPoint() {
            return this.zeroPoint;
        }
    }
}

