/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import ej.annotation.Nullable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpRetryException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.net.www.MessageHeader;
import sun.net.www.http.ChunkedOutputStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static String HTTP_CONNECT = "CONNECT";
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    @Nullable
    private StreamingOutputStream strOutputStream;
    private static final String RETRY_MSG2 = "cannot retry due to server authentication, in streaming mode";
    private static final String RETRY_MSG3 = "cannot retry due to redirection, in streaming mode";
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    @Nullable
    protected HttpClient http;
    protected Handler handler;
    @Nullable
    private MessageHeader cachedHeaders;
    @Nullable
    private InputStream cachedInputStream;
    @Nullable
    protected PrintStream ps = null;
    @Nullable
    private final InputStream errorStream = null;
    private MessageHeader requests = new MessageHeader();
    @Nullable
    String domain;
    private MessageHeader responses = new MessageHeader();
    @Nullable
    private InputStream inputStream = null;
    @Nullable
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    @Nullable
    private Exception rememberedException = null;
    @Nullable
    private HttpClient reuseClient = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    @Nullable
    String requestURI = null;
    @Nullable
    private Map<String, List<String>> filteredHeaders;

    static {
        maxRedirects = Integer.getInteger("http.maxRedirects", 20);
        version = System.getProperty("java.version");
        String agent = System.getProperty("http.agent");
        agent = agent == null ? "Java/" + version : String.valueOf(agent) + " Java/" + version;
        userAgent = agent;
    }

    private boolean isExternalMessageHeaderAllowed(String key, String value) {
        this.checkMessageHeader(key, value);
        return true;
    }

    private void checkMessageHeader(String key, @Nullable String value) {
        int LF = 10;
        int index = key.indexOf(LF);
        if (index != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + key);
        }
        if (value == null) {
            return;
        }
        index = value.indexOf(LF);
        while (index != -1) {
            char c;
            if (++index < value.length() && ((c = value.charAt(index)) == ' ' || c == '\t')) {
                index = value.indexOf(LF, index);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            if (!this.failedOnce) {
                this.requests.prepend(String.valueOf(this.method) + " " + this.getRequestURI() + " " + httpVersion, null);
            }
            if (!this.getUseCaches()) {
                this.requests.setIfNotSet("Cache-Control", "no-cache");
                this.requests.setIfNotSet("Pragma", "no-cache");
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int port = this.url.getPort();
            String host = this.url.getHost();
            if (port != -1 && port != this.url.getDefaultPort()) {
                host = String.valueOf(host) + ":" + String.valueOf(port);
            }
            this.requests.setIfNotSet("Host", host);
            this.requests.setIfNotSet("Accept", acceptString);
            this.requests.setIfNotSet("Connection", "close");
            if (!this.method.equals("PUT") && (this.poster != null || this.streaming())) {
                this.requests.setIfNotSet("Content-type", "application/x-www-form-urlencoded");
            }
            boolean chunked = false;
            if (this.streaming()) {
                if (this.chunkLength != -1) {
                    this.requests.set("Transfer-Encoding", "chunked");
                    chunked = true;
                } else if (this.fixedContentLengthLong != -1L) {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLengthLong));
                } else if (this.fixedContentLength != -1) {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLength));
                }
            } else if (this.poster != null) {
                PosterOutputStream posterOutputStream = this.poster;
                synchronized (posterOutputStream) {
                    this.poster.close();
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            if (!chunked && this.requests.findValue("Transfer-Encoding") != null) {
                this.requests.remove("Transfer-Encoding");
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests, this.poster, this.streaming());
        if (this.ps.checkError()) {
            this.disconnectInternal();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            this.setNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected void setNewClient(URL url) throws IOException {
        HttpClient http = this.http = HttpClient.New(url, this.connectTimeout, this);
        http.setReadTimeout(this.readTimeout);
    }

    public HttpURLConnection(URL u) {
        this(u, new Handler());
    }

    protected HttpURLConnection(URL u, Handler handler) {
        super(u);
        this.handler = handler;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        InputStream in;
        boolean redir;
        int redirects = 0;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || base.getPort() != target.getPort() || !HttpURLConnection.hostsEqual(base, target) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private static boolean hostsEqual(URL u1, URL u2) {
        String h1 = u1.getHost();
        String h2 = u2.getHost();
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        boolean[] result = new boolean[1];
        return result[0];
    }

    @Override
    public void connect() throws IOException {
        this.plainConnect();
    }

    private boolean checkReuseConnection() {
        if (this.connected) {
            return true;
        }
        HttpClient reuseClient = this.reuseClient;
        if (reuseClient != null) {
            HttpClient http = this.http = reuseClient;
            http.setReadTimeout(this.getReadTimeout());
            http.reuse = false;
            this.reuseClient = null;
            this.connected = true;
            return true;
        }
        return false;
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        if (!this.failedOnce) {
            this.http = this.getNewHttpClient(this.url, this.connectTimeout);
            this.http.setReadTimeout(this.readTimeout);
        } else {
            this.http = this.getNewHttpClient(this.url, this.connectTimeout);
            this.http.setReadTimeout(this.readTimeout);
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getNewHttpClient(URL url, int connectTimeout) throws IOException {
        return HttpClient.New(url, connectTimeout, this);
    }

    private void expect100Continue() throws IOException {
        int oldTimeout = this.http.getReadTimeout();
        boolean enforceTimeOut = false;
        boolean timedOut = false;
        if (oldTimeout <= 0) {
            this.http.setReadTimeout(5000);
            enforceTimeOut = true;
        }
        try {
            this.http.parseHTTP(this.responses, this);
        }
        catch (SocketTimeoutException se) {
            if (!enforceTimeOut) {
                throw se;
            }
            timedOut = true;
            this.http.setIgnoreContinue(true);
        }
        if (!timedOut) {
            String resp = this.responses.getValue(0);
            if (resp != null && resp.startsWith("HTTP/")) {
                String[] sa = HttpClient.splitWhitespace(resp);
                this.responseCode = -1;
                try {
                    if (sa.length > 1) {
                        this.responseCode = Integer.parseInt(sa[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (this.responseCode != 100) {
                throw new ProtocolException("Server rejected operation");
            }
        }
        this.http.setReadTimeout(oldTimeout);
        this.responseCode = -1;
        this.responses.reset();
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            boolean expectContinue = false;
            String expects = this.requests.findValue("Expect");
            if ("100-Continue".equalsIgnoreCase(expects)) {
                this.http.setIgnoreContinue(false);
                expectContinue = true;
            }
            if (this.streaming() && this.strOutputStream == null) {
                this.writeRequests();
            }
            if (expectContinue) {
                this.expect100Continue();
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.streaming()) {
                if (this.strOutputStream == null) {
                    if (this.chunkLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(new ChunkedOutputStream(this.ps, this.chunkLength), -1L);
                    } else {
                        long length = 0L;
                        if (this.fixedContentLengthLong != -1L) {
                            length = this.fixedContentLengthLong;
                        } else if (this.fixedContentLength != -1) {
                            length = this.fixedContentLength;
                        }
                        this.strOutputStream = new StreamingOutputStream(this.ps, length);
                    }
                }
                return this.strOutputStream;
            }
            PosterOutputStream poster = this.poster;
            if (poster == null) {
                poster = this.poster = new PosterOutputStream();
            }
            return poster;
        }
        catch (RuntimeException e) {
            this.disconnectInternal();
            throw e;
        }
        catch (ProtocolException e) {
            int i = this.responseCode;
            this.disconnectInternal();
            this.responseCode = i;
            throw e;
        }
        catch (IOException e) {
            this.disconnectInternal();
            throw e;
        }
    }

    public boolean streaming() {
        return this.fixedContentLength != -1 || this.fixedContentLengthLong != -1L || this.chunkLength != -1;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.rememberedException != null) {
            if (this.rememberedException instanceof RuntimeException) {
                throw new RuntimeException(this.rememberedException);
            }
            throw new IOException(this.rememberedException);
        }
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            return inputStream;
        }
        if (this.streaming()) {
            if (this.strOutputStream == null) {
                this.getOutputStream();
            }
            this.strOutputStream.close();
            if (!this.strOutputStream.writtenOK()) {
                throw new IOException("Incomplete output stream");
            }
        }
        int redirects = 0;
        int respCode = 0;
        long cl = -1L;
        try {
            do {
                InputStream cachedInputStream;
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
                if ((cachedInputStream = this.cachedInputStream) != null) {
                    return cachedInputStream;
                }
                this.ps = (PrintStream)this.http.getOutputStream();
                if (!this.streaming()) {
                    this.writeRequests();
                }
                this.http.parseHTTP(this.responses, this);
                this.inputStream = this.http.getInputStream();
                respCode = this.getResponseCode();
                if (respCode == -1) {
                    this.disconnectInternal();
                    throw new IOException("Invalid Http response");
                }
                if (respCode != 407) {
                    this.requests.remove("Proxy-Authorization");
                }
                if (respCode == 401 && this.streaming()) {
                    this.disconnectInternal();
                    throw new HttpRetryException(RETRY_MSG2, 401);
                }
                this.requests.remove("Authorization");
                this.requests.remove("Proxy-Authorization");
                if (this.followRedirect()) continue;
                try {
                    cl = Long.parseLong(this.responses.findValue("content-length"));
                }
                catch (Exception exception) {}
                if (this.method.equals("HEAD") || cl == 0L || respCode == 304 || respCode == 204) {
                    this.http.finished();
                    this.http = null;
                    this.inputStream = new EmptyInputStream();
                    this.connected = false;
                }
                if (respCode == 200 || respCode == 203 || respCode == 206 || respCode == 300 || respCode != 301) {
                    // empty if block
                }
                if (respCode >= 400) {
                    if (respCode == 404 || respCode == 410) {
                        throw new IOException(this.url.toString());
                    }
                    throw new IOException("Server returned HTTP response code: " + respCode + " for URL: " + this.url.toString());
                }
                this.poster = null;
                this.strOutputStream = null;
                return this.inputStream;
            } while (++redirects < maxRedirects);
            throw new ProtocolException("Server redirected too many  times (" + redirects + ")");
        }
        catch (RuntimeException e) {
            this.disconnectInternal();
            this.rememberedException = e;
            throw e;
        }
        catch (IOException e) {
            this.rememberedException = e;
            throw e;
        }
    }

    @Override
    @Nullable
    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400) {
            if (this.errorStream != null) {
                return this.errorStream;
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
        }
        return null;
    }

    static String connectRequestURI(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        port = port != -1 ? port : url.getDefaultPort();
        return String.valueOf(host) + ":" + port;
    }

    String getRequestURI() throws IOException {
        String requestURI = this.requestURI;
        if (requestURI == null) {
            requestURI = this.requestURI = this.http.getURLFile();
        }
        return requestURI;
    }

    private boolean followRedirect() throws IOException {
        URL locUrl;
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 307 || stat == 306 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        try {
            locUrl = new URL(loc);
            if (!this.url.getProtocol().equalsIgnoreCase(locUrl.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            locUrl = new URL(this.url, loc);
        }
        this.disconnectInternal();
        if (this.streaming()) {
            throw new HttpRetryException(RETRY_MSG3, stat, loc);
        }
        this.responses = new MessageHeader();
        this.url = locUrl;
        this.requestURI = null;
        if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && stat != 307) {
            this.requests = new MessageHeader();
            this.setRequests = false;
            this.setRequestMethod("GET");
            this.poster = null;
            if (!this.checkReuseConnection()) {
                this.connect();
            }
        } else {
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            if (this.http != null) {
                this.requests.set(0, String.valueOf(this.method) + " " + this.getRequestURI() + " " + httpVersion, null);
                int port = this.url.getPort();
                String host = this.url.getHost();
                if (port != -1 && port != this.url.getDefaultPort()) {
                    host = String.valueOf(host) + ":" + String.valueOf(port);
                }
                this.requests.set("Host", host);
            }
        }
        return true;
    }

    private void disconnectInternal() {
        this.responseCode = -1;
        this.inputStream = null;
        HttpClient http = this.http;
        if (http != null) {
            http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    @Override
    public void disconnect() {
        this.responseCode = -1;
        HttpClient http = this.http;
        if (http != null) {
            InputStream inputStream = this.inputStream;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                http.setDoNotRetry(true);
                http.closeServer();
            }
            this.http = null;
            this.connected = false;
        }
        this.cachedInputStream = null;
        MessageHeader cachedHeaders = this.cachedHeaders;
        if (cachedHeaders != null) {
            cachedHeaders.reset();
        }
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Nullable
    private String filterHeaderField(@Nullable String name, @Nullable String value) {
        if (value == null) {
            return null;
        }
        return value;
    }

    private Map<String, List<String>> getFilteredHeaderFields() {
        Map<String, List<String>> filteredHeaders = this.filteredHeaders;
        if (filteredHeaders != null) {
            return filteredHeaders;
        }
        HashMap tmpMap = new HashMap();
        MessageHeader cachedHeaders = this.cachedHeaders;
        Map<String, List<String>> headers = cachedHeaders != null ? cachedHeaders.getHeaders() : this.responses.getHeaders();
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String key = e.getKey();
            List<String> values = e.getValue();
            ArrayList<String> filteredVals = new ArrayList<String>();
            for (String value : values) {
                String fVal = this.filterHeaderField(key, value);
                if (fVal == null) continue;
                filteredVals.add(fVal);
            }
            if (filteredVals.isEmpty()) continue;
            tmpMap.put(key, Collections.unmodifiableList(filteredVals));
        }
        this.filteredHeaders = Collections.unmodifiableMap(tmpMap);
        return this.filteredHeaders;
    }

    @Override
    @Nullable
    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        MessageHeader cachedHeaders = this.cachedHeaders;
        if (cachedHeaders != null) {
            return this.filterHeaderField(name, cachedHeaders.findValue(name));
        }
        return this.filterHeaderField(name, this.responses.findValue(name));
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        return this.getFilteredHeaderFields();
    }

    @Override
    @Nullable
    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        MessageHeader cachedHeaders = this.cachedHeaders;
        if (cachedHeaders != null) {
            return this.filterHeaderField(cachedHeaders.getKey(n), cachedHeaders.getValue(n));
        }
        return this.filterHeaderField(this.responses.getKey(n), this.responses.getValue(n));
    }

    @Override
    @Nullable
    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {}
        MessageHeader cachedHeaders = this.cachedHeaders;
        if (cachedHeaders != null) {
            return cachedHeaders.getKey(n);
        }
        return this.responses.getKey(n);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (this.isExternalMessageHeaderAllowed(key, value)) {
            this.requests.set(key, value);
        }
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (this.isExternalMessageHeaderAllowed(key, value)) {
            this.requests.add(key, value);
        }
    }

    public void setAuthenticationProperty(String key, String value) {
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    @Override
    @Nullable
    public synchronized String getRequestProperty(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.requests.findValue(key);
    }

    @Override
    public synchronized Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requests.filterAndAddHeaders(null, null);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = timeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    String getMethod() {
        return this.method;
    }

    class StreamingOutputStream
    extends FilterOutputStream {
        long expected;
        long written;
        boolean closed;
        boolean error;
        @Nullable
        IOException errorExcp;

        StreamingOutputStream(OutputStream os, long expectedLength) {
            super(os);
            this.expected = expectedLength;
            this.written = 0L;
            this.closed = false;
            this.error = false;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkError();
            ++this.written;
            if (this.expected != -1L && this.written > this.expected) {
                throw new IOException("too many bytes written");
            }
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkError();
            this.written += (long)len;
            if (this.expected != -1L && this.written > this.expected) {
                this.out.close();
                throw new IOException("too many bytes written");
            }
            this.out.write(b, off, len);
        }

        void checkError() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.error) {
                throw this.errorExcp;
            }
            if (((PrintStream)this.out).checkError()) {
                throw new IOException("Error writing request body to server");
            }
        }

        boolean writtenOK() {
            return this.closed && !this.error;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.expected != -1L) {
                if (this.written != this.expected) {
                    this.error = true;
                    IOException errorExcp = this.errorExcp = new IOException("insufficient data written");
                    this.out.close();
                    throw errorExcp;
                }
                super.flush();
            } else {
                super.close();
                OutputStream o = HttpURLConnection.this.http.getOutputStream();
                o.write(13);
                o.write(10);
                o.flush();
            }
        }
    }
}

