/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.websocket.frame.RawFrame;
import java.util.logging.Logger;

public class PrettyFramePrinter {
    private static final String BEGIN_END_MARKER = "---------------------------------------------";
    private final Logger out;

    public PrettyFramePrinter(Logger out) {
        this.out = out;
    }

    public PrettyFramePrinter() {
        this(Logger.getGlobal());
    }

    public void print(RawFrame f) {
        byte b;
        int n;
        int n2;
        byte[] byArray;
        StringBuilder builder = new StringBuilder();
        builder.append("---------------------------------------------\n");
        builder.append("FIN\t" + f.getFIN() + "\n");
        builder.append("RSV\t" + f.getRSV() + "\n");
        builder.append("Opcode\t" + f.getOpcode() + "\n");
        builder.append("Mask\t" + f.getMASK() + "\n");
        builder.append("Length\t" + f.getLength() + "\n");
        if (f.hasExtendedLength()) {
            long extLength = f.getExtendedLength();
            builder.append("Extended Length\t" + extLength + "\n");
        }
        if (f.isMasked()) {
            byte[] maskingKey;
            builder.append("Masking key\t");
            byArray = maskingKey = f.getMaskingKey();
            n2 = maskingKey.length;
            n = 0;
            while (n < n2) {
                b = byArray[n];
                builder.append(b);
                builder.append("\t");
                ++n;
            }
            builder.append("\n");
        }
        builder.append("Payload\t");
        switch (f.getOpcode()) {
            case 1: {
                byte[] payload = f.getPayload(false);
                builder.append(String.valueOf(new String(payload)) + "\n");
            }
            case 2: 
            case 9: 
            case 10: {
                byte[] payload = f.getPayload(false);
                byArray = payload;
                n2 = payload.length;
                n = 0;
                while (n < n2) {
                    b = byArray[n];
                    builder.append(b);
                    builder.append(' ');
                    ++n;
                }
                builder.append('\n');
                break;
            }
            default: {
                builder.append("ERROR: not managed " + f.getOpcode() + "\n");
            }
        }
        builder.append("---------------------------------------------\n");
        this.out.info(builder.toString());
    }
}

