/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.bon.ByteArray;
import ej.websocket.Messages;
import ej.websocket.ReasonForClosure;
import ej.websocket.frame.IFrameBuilder;
import ej.websocket.frame.RawFrame;
import java.util.Random;

public class ClientFrameBuilder
implements IFrameBuilder {
    private static final Random RANDOM = new Random();

    private static byte[] buildGenericFrame(int opcode, byte[] payload) {
        long frameLength = ClientFrameBuilder.computeFrameLength(payload);
        if (frameLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        byte[] bytes = new byte[(int)frameLength];
        int offset = 0;
        bytes[offset] = (byte)((byte)(opcode & 0xFF) | 0x80);
        ++offset;
        int payloadLength = payload.length;
        if (payloadLength <= 125) {
            bytes[offset] = (byte)(0x80 | payloadLength);
            ++offset;
        } else if (payloadLength <= 65535) {
            bytes[offset] = -2;
            bytes[offset + 1] = (byte)((payloadLength & 0xFF00) >> 8);
            bytes[offset + 2] = (byte)(payloadLength & 0xFF);
            offset += 3;
        } else {
            bytes[offset] = -1;
            ByteArray.writeLong((byte[])bytes, (int)(offset + 1), (long)payloadLength, (int)1);
            offset += 9;
        }
        byte[] mask = new byte[4];
        RANDOM.nextBytes(mask);
        bytes[offset + 0] = mask[0];
        bytes[offset + 1] = mask[1];
        bytes[offset + 2] = mask[2];
        bytes[offset + 3] = mask[3];
        offset += 4;
        int i = 0;
        while (i < payloadLength) {
            bytes[offset + i] = (byte)(payload[i] ^ mask[i % 4]);
            ++i;
        }
        return bytes;
    }

    static long computeFrameLength(byte[] payload) {
        return ClientFrameBuilder.computeFrameLength(payload.length);
    }

    static long computeFrameLength(long payloadLength) {
        int frameLength = 6;
        if (payloadLength <= 125L) {
            frameLength = (int)((long)frameLength + payloadLength);
        } else if (payloadLength <= 65535L) {
            frameLength += 2;
            frameLength = (int)((long)frameLength + payloadLength);
        } else {
            frameLength += 8;
            frameLength = (int)((long)frameLength + payloadLength);
        }
        return frameLength;
    }

    @Override
    public RawFrame buildBinaryFrame(byte[] binary) {
        byte[] payload = binary == null ? new byte[]{} : binary;
        byte[] bytes = ClientFrameBuilder.buildGenericFrame(2, payload);
        return new RawFrame(bytes);
    }

    @Override
    public RawFrame buildCloseFrame(ReasonForClosure reasonForClosure) {
        byte[] payload = new byte[]{};
        int length = 2 + reasonForClosure.getCloseReason().length();
        payload = new byte[length];
        int code = reasonForClosure.getCloseCode();
        payload[0] = (byte)((code & 0xFF00) >> 8);
        payload[1] = (byte)((code & 0xFF) >> 0);
        System.arraycopy(reasonForClosure.getCloseReason().getBytes(), 0, payload, 2, length - 2);
        byte[] bytes = ClientFrameBuilder.buildGenericFrame(8, payload);
        return new RawFrame(bytes);
    }

    @Override
    public RawFrame buildPingFrame(byte[] binary) {
        byte[] payload = binary == null ? new byte[]{} : binary;
        byte[] bytes = ClientFrameBuilder.buildGenericFrame(9, payload);
        return new RawFrame(bytes);
    }

    @Override
    public RawFrame buildPongFrame(byte[] binary) {
        byte[] payload = binary == null ? new byte[]{} : binary;
        byte[] bytes = ClientFrameBuilder.buildGenericFrame(10, payload);
        return new RawFrame(bytes);
    }

    @Override
    public RawFrame buildTextFrame(String text) {
        byte[] payload = text == null ? new byte[]{} : text.getBytes();
        byte[] bytes = ClientFrameBuilder.buildGenericFrame(1, payload);
        return new RawFrame(bytes);
    }
}

