/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.websocket.CloseCodes;
import ej.websocket.Messages;
import ej.websocket.util.ArraysTools;
import ej.websocket.util.UTF8Validator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class RawFrame {
    private static final int VERY_EXTENDED_LENGTH = 65535;
    private static final int BYTE_MAX_VALUE = 127;
    public static final byte OPCODE_CONTINUATION_FRAME = 0;
    public static final byte OPCODE_TEXT_FRAME = 1;
    public static final byte OPCODE_BINARY_FRAME = 2;
    public static final byte OPCODE_CONNECTION_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private byte[] bytes;

    public RawFrame(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        int length = bytes.length;
        this.bytes = new byte[length];
        System.arraycopy(bytes, 0, this.bytes, 0, length);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte getFIN() {
        return (byte)((this.bytes[0] & 0x80) >> 7);
    }

    public byte getRSV() {
        return (byte)((this.bytes[0] & 0x70) >> 4);
    }

    public byte getOpcode() {
        return (byte)(this.bytes[0] & 0xF);
    }

    public boolean hasValidOpcode() {
        byte code = this.getOpcode();
        return code == 0 || code == 1 || code == 2 || code == 8 || code == 9 || code == 10;
    }

    public byte getMASK() {
        return (byte)((this.bytes[1] & 0x80) >> 7);
    }

    public boolean isControlFrame() {
        byte opcode = this.getOpcode();
        return (opcode & 8) != 0;
    }

    public boolean isMasked() {
        return this.getMASK() == 1;
    }

    public boolean isValid() throws IOException {
        if (!this.hasValidOpcode()) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -1));
        }
        if (this.getOpcode() == 1 && this.getLength() != 0 && !UTF8Validator.isValid(this.bytes, this.getPayloadOffset(), this.getPayloadLength())) {
            throw new UnsupportedEncodingException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -2));
        }
        if (this.isControlFrame()) {
            this.isControlValid();
        }
        return true;
    }

    private void isControlValid() throws IOException, UnsupportedEncodingException {
        if (this.getFIN() != 1) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -5));
        }
        if (this.getLength() > 125) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -6, new Object[]{this.getLength()}));
        }
        if (this.getOpcode() == 8) {
            if (this.getLength() == 1) {
                throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9));
            }
            if (this.getLength() >= 2) {
                int lsb;
                byte[] payload = this.getPayload(true);
                int msb = payload[0] & 0xFF;
                int code = (msb << 8) + (lsb = payload[1] & 0xFF);
                if (!CloseCodes.canBeUsedInCloseFrame(code)) {
                    throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -7, new Object[]{code}));
                }
                if (!UTF8Validator.isValid(payload, 2, payload.length - 2)) {
                    throw new UnsupportedEncodingException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -2));
                }
            }
        }
    }

    public byte getLength() {
        return (byte)(this.bytes[1] & 0x7F);
    }

    public boolean hasExtendedLength() {
        return this.getLength() == 126;
    }

    public int getExtendedLength() {
        if (this.hasExtendedLength()) {
            int msb = this.bytes[2] & 0xFF;
            int lsb = this.bytes[3] & 0xFF;
            return (msb << 8) + lsb;
        }
        return 0;
    }

    public void setLength(int length) {
        int previousLength = this.getPayloadLength();
        if (previousLength >= 127 && length < 127) {
            this.bytes = ArraysTools.removeRange(this.bytes, 2, 2);
        } else if (previousLength < 127 && length >= 127) {
            this.bytes = ArraysTools.insertRange(this.bytes, 2, 2);
        }
        this.bytes[1] = (byte)(this.bytes[1] | 0x7F);
        this.bytes[1] = (byte)(Math.min(length, 126) & 0x7F);
        if (length >= 127) {
            this.bytes[2] = (byte)(length >> 8 & 0xFF);
            this.bytes[3] = (byte)(length & 0xFF);
        }
    }

    public byte[] getMaskingKey() {
        if (this.isMasked()) {
            byte[] maskingKey = new byte[4];
            int offset = this.hasExtendedLength() ? 4 : 2;
            System.arraycopy(this.bytes, offset, maskingKey, 0, 4);
            return maskingKey;
        }
        return null;
    }

    public byte[] getPayload(boolean unmaskIfNeeded) {
        if (this.isMasked() && unmaskIfNeeded) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        int offset = this.getPayloadOffset();
        int payloadLength = this.getPayloadLength();
        byte[] payload = new byte[payloadLength];
        System.arraycopy(this.bytes, offset, payload, 0, payloadLength);
        return payload;
    }

    public int getPayloadLength() {
        int payloadLength = this.getLength();
        if (this.hasExtendedLength()) {
            payloadLength = this.getExtendedLength();
        }
        return payloadLength;
    }

    private int getPayloadOffset() {
        int offset = 2;
        if (this.hasExtendedLength()) {
            offset += 2;
        }
        if (this.isMasked()) {
            offset += 4;
        }
        return offset;
    }

    public synchronized void append(RawFrame f) {
        int currentOffset = this.getPayloadOffset();
        int currentPayloadLength = this.getPayloadLength();
        byte[] fBytes = f.getBytes();
        int currentLength = currentOffset + currentPayloadLength;
        int fPayloadLength = f.getPayloadLength();
        int length = fPayloadLength + currentPayloadLength;
        if (length > 65535) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        this.bytes = ArraysTools.add(this.bytes, 0, currentLength, fBytes, f.getPayloadOffset(), fPayloadLength);
        this.setLength(length);
    }
}

