/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.encoding;

import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;
import ej.hoka.http.encoding.TransferEncoding;
import ej.hoka.io.IdentityMessageBodyInputStream;
import ej.hoka.io.IdentityMessageBodyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IdentityTransferEncoding
implements TransferEncoding {
    private static IdentityTransferEncoding instance;

    private IdentityTransferEncoding() {
    }

    public static IdentityTransferEncoding getInstance() {
        if (instance == null) {
            instance = new IdentityTransferEncoding();
        }
        return instance;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public InputStream open(HttpRequest request, InputStream input) throws IOException {
        int bodyLength = 0;
        String contentLength = request.getHeader("content-length");
        if (contentLength != null) {
            bodyLength = Integer.parseInt(contentLength);
        }
        return new IdentityMessageBodyInputStream(input, bodyLength);
    }

    @Override
    public OutputStream open(HttpResponse response, OutputStream output) throws IOException {
        return new IdentityMessageBodyOutputStream(output);
    }
}

