/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool;

public class ThreadUtils {
    private ThreadUtils() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    public static void handleUncaughtException(Throwable t) {
        Thread currentThread = Thread.currentThread();
        Thread.UncaughtExceptionHandler handler = currentThread.getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            handler.uncaughtException(currentThread, t);
        } else {
            t.printStackTrace();
        }
    }

    @Deprecated
    public static void handleUncaughtException(Exception e) {
        ThreadUtils.handleUncaughtException((Throwable)e);
    }
}

