/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLEncoder {
    static BitSet dontNeedEncoding = new BitSet(256);
    static final int caseDiff = 32;

    static {
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    private URLEncoder() {
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        StringBuilder out = new StringBuilder(s.length());
        StringBuilder needEncoding = new StringBuilder();
        if (enc == null) {
            throw new NullPointerException("charsetName");
        }
        int i = 0;
        while (i < s.length()) {
            char c;
            int c2 = s.charAt(i);
            if (dontNeedEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                    needToChange = true;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                needEncoding.append((char)c2);
                if (c2 >= 55296 && c2 <= 56319) {
                    throw new RuntimeException("Surrogate pair not supported");
                }
                if (++i >= s.length()) break;
                c = s.charAt(i);
                c2 = c;
            } while (!dontNeedEncoding.get(c));
            String str = needEncoding.toString();
            byte[] ba = str.getBytes(enc);
            int j = 0;
            while (j < ba.length) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (URLEncoder.Character_isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (URLEncoder.Character_isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ++j;
            }
            needEncoding.setLength(0);
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    private static boolean Character_isLetter(char character) {
        return Character.isLowerCase(character) || Character.isUpperCase(character);
    }
}

