/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.dimension;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.Display;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.style.Style;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.dimension.DimensionHelper;
import ej.mwt.util.OutlineHelper;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;

public class RelativeDimension
implements Dimension {
    private final float widthRatio;
    private final float heightRatio;

    public RelativeDimension(float widthRatio, float heightRatio) {
        this.widthRatio = XMath.limit((float)widthRatio, (float)0.0f, (float)1.0f);
        this.heightRatio = XMath.limit((float)heightRatio, (float)0.0f, (float)1.0f);
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public float getHeightRatio() {
        return this.heightRatio;
    }

    @Override
    public void getAvailableSize(Widget widget, int availableWidth, int availableHeight, Size availableSize) {
        if (this.widthRatio != 0.0f) {
            availableSize.setWidth((int)(this.widthRatio * (float)availableWidth));
        }
        if (this.heightRatio != 0.0f) {
            availableSize.setHeight((int)(this.heightRatio * (float)availableHeight));
        }
    }

    @Override
    public void computeOptimalSize(Widget widget, int availableWidth, int availableHeight, Size optimalSize) {
        if (this.widthRatio != 0.0f) {
            optimalSize.setWidth((int)(this.widthRatio * (float)availableWidth));
        }
        if (this.heightRatio != 0.0f) {
            optimalSize.setHeight((int)(this.heightRatio * (float)availableHeight));
        }
    }

    @Override
    public void layOut(Widget widget, Rectangle bounds) {
        int parentHeight;
        int parentWidth;
        Container parent = widget.getParent();
        if (parent == null) {
            Display display = Display.getDisplay();
            parentWidth = display.getWidth();
            parentHeight = display.getHeight();
        } else {
            parentWidth = parent.getWidth();
            parentHeight = parent.getHeight();
        }
        Style style = widget.getStyle();
        int leftOutlines = -bounds.getX();
        int topOutlines = -bounds.getY();
        int rightOutlines = bounds.getWidth();
        int bottomOutlines = bounds.getHeight();
        OutlineHelper.applyOutlines(bounds, style);
        DimensionHelper.layOut(widget, bounds, this.widthRatio != 0.0f, this.heightRatio != 0.0f, (int)(this.widthRatio * (float)parentWidth), (int)(this.heightRatio * (float)parentHeight));
        bounds.addOutline(leftOutlines, topOutlines, rightOutlines -= bounds.getWidth() + (leftOutlines += bounds.getX()), bottomOutlines -= bounds.getHeight() + (topOutlines += bounds.getY()));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RelativeDimension) {
            RelativeDimension dimension = (RelativeDimension)obj;
            return this.widthRatio == dimension.widthRatio && this.heightRatio == dimension.heightRatio;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)(this.widthRatio * 300.0f + this.heightRatio * 500.0f);
    }
}

