/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.mwt.style.background.Background;

public class RoundedBackground
implements Background {
    private final int color;
    private final char cornerRadius;

    public RoundedBackground(int color, int cornerRadius) {
        this.color = color;
        this.cornerRadius = (char)XMath.limit((int)cornerRadius, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public boolean isTransparent(int width, int height) {
        return true;
    }

    @Override
    public void apply(GraphicsContext g, int width, int height) {
        int cornerRadius = Math.min(this.cornerRadius, Math.min(width, height) - 1 >> 1);
        g.setColor(this.color);
        Painter.fillRoundedRectangle((GraphicsContext)g, (int)1, (int)1, (int)(width - 2), (int)(height - 2), (int)(cornerRadius << 1), (int)(cornerRadius << 1));
        g.setBackgroundColor(this.color);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RoundedBackground) {
            RoundedBackground background = (RoundedBackground)obj;
            return this.color == background.color && this.cornerRadius == background.cornerRadius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.color + this.cornerRadius;
    }
}

