/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;

class HeapLongBuffer
extends LongBuffer {
    HeapLongBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new long[cap], 0);
    }

    HeapLongBuffer(long[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapLongBuffer(long[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public LongBuffer slice() {
        long[] hb = this.hb;
        assert (hb != null);
        return new HeapLongBuffer(hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public LongBuffer duplicate() {
        long[] hb = this.hb;
        assert (hb != null);
        return new HeapLongBuffer(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        long[] hb = this.hb;
        assert (hb != null);
        return new HeapLongBufferR(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public long get() {
        long[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public long get(int i) {
        long[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        HeapLongBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        long[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public LongBuffer put(long x) {
        long[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        long[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        HeapLongBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        long[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(src, offset, hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        long[] hb = this.hb;
        assert (hb != null);
        if (src instanceof HeapLongBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapLongBuffer sb = (HeapLongBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            long[] srcHb = sb.hb;
            assert (srcHb != null);
            System.arraycopy(srcHb, sb.ix(sb.position()), hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        long[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

