/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class StartAdvertisingEndpoint
implements Endpoint {
    @Nullable
    private byte[] advertisementData;

    public String getName() {
        return "bluetooth_start_advertising";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.advertisementData = reader.readByteArray();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        byte[] advertisementData = this.advertisementData;
        assert (advertisementData != null);
        if (BluetoothAdapter.getAdapter().startAdvertising(advertisementData)) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

