/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.bon.Constants;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.render.RenderPolicy;
import ej.widget.debug.BoundsInspector;
import ej.widget.debug.HierarchyInspector;
import java.util.logging.Logger;

public class RenderMonitor
implements RenderPolicy.RenderListener {
    private static final String DEBUG_RENDER_FRAMES_CONSTANT = "ej.mwt.debug.render.frames";
    private static final Logger LOGGER = Logger.getLogger(RenderMonitor.class.getSimpleName());

    public void onRenderRequested(Widget widget, int x, int y, int width, int height) {
        LOGGER.info(RenderMonitor.buildMessage("Render requested on ", widget, x, y, width, height, true));
    }

    public void onRenderExecuted(Widget widget, int x, int y, int width, int height) {
        LOGGER.info(RenderMonitor.buildMessage("Render executed on  ", widget, x, y, width, height, false));
    }

    private static String buildMessage(String prefix, Widget widget, int x, int y, int width, int height, boolean appendCaller) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(HierarchyInspector.pathToWidgetToString(widget));
        builder.append(" at {").append(x).append(',').append(y).append(' ').append(width).append('x').append(height).append("} of {");
        BoundsInspector.appendAbsolutePosition(builder, widget);
        builder.append(' ');
        BoundsInspector.appendSize(builder, widget);
        builder.append('}');
        if (appendCaller) {
            RenderMonitor.appendCaller(builder);
        }
        return builder.toString();
    }

    private static void appendCaller(StringBuilder builder) {
        int frames = Constants.getInt((String)DEBUG_RENDER_FRAMES_CONSTANT);
        if (frames <= 0) {
            return;
        }
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int start = RenderMonitor.skipInternalFrames(stacktrace);
        builder.append(frames == 1 ? " " : "\n\t");
        builder.append("by ");
        StackTraceElement frame = stacktrace[start];
        assert (frame != null);
        RenderMonitor.appendFrame(builder, frame);
        int i = 1;
        int n = stacktrace.length;
        while (i < frames && start + i < n) {
            builder.append("\n\tat ");
            frame = stacktrace[start + i];
            assert (frame != null);
            RenderMonitor.appendFrame(builder, frame);
            ++i;
        }
    }

    private static void appendFrame(StringBuilder builder, StackTraceElement frame) {
        String className = frame.getClassName();
        String methodName = frame.getMethodName();
        className = HierarchyInspector.canonizeClassName(className);
        builder.append(className).append('.').append(methodName).append('(');
        String fileName = frame.getFileName();
        if (fileName != null) {
            int lineNumber = frame.getLineNumber();
            builder.append(fileName).append(':').append(lineNumber);
        }
        builder.append(')');
    }

    /*
     * Unable to fully structure code
     */
    private static int skipInternalFrames(StackTraceElement[] stacktrace) {
        renderMonitor = RenderMonitor.class.getName();
        desktop = Desktop.class.getName();
        widget = Widget.class.getName();
        i = 0;
        while (!stacktrace[i].getClassName().equals(renderMonitor)) {
            ++i;
        }
        if (RenderMonitor.$assertionsDisabled || i < stacktrace.length) ** GOTO lbl11
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            ++i;
lbl11:
            // 2 sources

            ** while (!stacktrace[i].getClassName().equals((Object)desktop))
        }
lbl12:
        // 1 sources

        if (!RenderMonitor.$assertionsDisabled && i >= stacktrace.length) {
            throw new AssertionError();
        }
        if (RenderMonitor.$assertionsDisabled || ++i < stacktrace.length) ** GOTO lbl17
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            ++i;
lbl17:
            // 2 sources

            ** while (stacktrace[i].getClassName().equals((Object)widget))
        }
lbl18:
        // 1 sources

        if (!RenderMonitor.$assertionsDisabled && i >= stacktrace.length) {
            throw new AssertionError();
        }
        return i;
    }
}

