/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.time.IntegerHelper;
import java.time.MutableBigInteger;
import java.util.Arrays;

class BigInteger
extends Number
implements Comparable<BigInteger> {
    final int signum;
    final int[] mag;
    static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    static final BigInteger ZERO = new BigInteger(new int[0], 0);

    BigInteger(int[] magnitude, int signum) {
        this.signum = magnitude.length == 0 ? 0 : signum;
        this.mag = magnitude;
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private void checkRange() {
        if (this.mag.length > 0x4000000 || this.mag.length == 0x4000000 && this.mag[0] < 0) {
            BigInteger.reportOverflow();
        }
    }

    private static void reportOverflow() {
        throw new ArithmeticException("BigInteger would overflow supported range");
    }

    static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        return new BigInteger(val);
    }

    private BigInteger(long val) {
        if (val < 0L) {
            val = -val;
            this.signum = -1;
        } else {
            this.signum = 1;
        }
        int highWord = (int)(val >>> 32);
        if (highWord == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)val;
        } else {
            this.mag = new int[2];
            this.mag[0] = highWord;
            this.mag[1] = (int)val;
        }
    }

    BigInteger add(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val;
        }
        if (val.signum == this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    /*
     * Unable to fully structure code
     */
    private static int[] add(int[] x, int[] y) {
        block5: {
            if (x.length < y.length) {
                tmp = x;
                x = y;
                y = tmp;
            }
            xIndex = x.length;
            yIndex = y.length;
            result = new int[xIndex];
            sum = 0L;
            if (yIndex != 1) ** GOTO lbl15
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL);
            result[xIndex] = (int)sum;
            break block5;
lbl-1000:
            // 1 sources

            {
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[--yIndex] & 0xFFFFFFFFL) + (sum >>> 32);
                result[xIndex] = (int)sum;
lbl15:
                // 2 sources

                ** while (yIndex > 0)
            }
        }
        carry = sum >>> 32 != 0L;
        while (xIndex > 0 && carry) {
            result[--xIndex] = x[xIndex] + 1;
            v0 = carry = result[--xIndex] == 0;
        }
        while (xIndex > 0) {
            result[--xIndex] = x[xIndex];
        }
        if (carry) {
            bigger = new int[result.length + 1];
            System.arraycopy(result, 0, bigger, 1, result.length);
            bigger[0] = 1;
            return bigger;
        }
        return result;
    }

    BigInteger subtract(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val.negate();
        }
        if (val.signum != this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    private static int[] subtract(int[] big, int[] little) {
        int bigIndex = big.length;
        int[] result = new int[bigIndex];
        int littleIndex = little.length;
        long difference = 0L;
        while (littleIndex > 0) {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
            result[bigIndex] = (int)difference;
        }
        boolean borrow = difference >> 32 != 0L;
        while (bigIndex > 0 && borrow) {
            result[--bigIndex] = big[bigIndex] - 1;
            boolean bl = borrow = result[--bigIndex] == -1;
        }
        while (bigIndex > 0) {
            result[--bigIndex] = big[bigIndex];
        }
        return result;
    }

    BigInteger multiply(BigInteger val) {
        if (val.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        int xlen = this.mag.length;
        if (val == this && xlen > 20) {
            return this.square();
        }
        int ylen = val.mag.length;
        if (xlen < 80 || ylen < 80) {
            int resultSign;
            int n = resultSign = this.signum == val.signum ? 1 : -1;
            if (val.mag.length == 1) {
                return BigInteger.multiplyByInt(this.mag, val.mag[0], resultSign);
            }
            if (this.mag.length == 1) {
                return BigInteger.multiplyByInt(val.mag, this.mag[0], resultSign);
            }
            int[] result = this.multiplyToLen(this.mag, xlen, val.mag, ylen, null);
            result = BigInteger.trustedStripLeadingZeroInts(result);
            return new BigInteger(result, resultSign);
        }
        if (xlen < 240 && ylen < 240) {
            return BigInteger.multiplyKaratsuba(this, val);
        }
        return BigInteger.multiplyToomCook3(this, val);
    }

    private static BigInteger multiplyByInt(int[] x, int y, int sign) {
        if (IntegerHelper.bitCount(y) == 1) {
            return new BigInteger(BigInteger.shiftLeft(x, IntegerHelper.numberOfTrailingZeros(y)), sign);
        }
        int xlen = x.length;
        int[] rmag = new int[xlen + 1];
        long carry = 0L;
        long yl = (long)y & 0xFFFFFFFFL;
        int rstart = rmag.length - 1;
        int i = xlen - 1;
        while (i >= 0) {
            long product = ((long)x[i] & 0xFFFFFFFFL) * yl + carry;
            rmag[rstart--] = (int)product;
            carry = product >>> 32;
            --i;
        }
        if (carry == 0L) {
            rmag = Arrays.copyOfRange(rmag, 1, rmag.length);
        } else {
            rmag[rstart] = (int)carry;
        }
        return new BigInteger(rmag, sign);
    }

    BigInteger multiply(long v) {
        long product;
        int rsign;
        if (v == 0L || this.signum == 0) {
            return ZERO;
        }
        int n = rsign = v > 0L ? this.signum : -this.signum;
        if (v < 0L) {
            v = -v;
        }
        long dh = v >>> 32;
        long dl = v & 0xFFFFFFFFL;
        int xlen = this.mag.length;
        int[] value = this.mag;
        int[] rmag = dh == 0L ? new int[xlen + 1] : new int[xlen + 2];
        long carry = 0L;
        int rstart = rmag.length - 1;
        int i = xlen - 1;
        while (i >= 0) {
            product = ((long)value[i] & 0xFFFFFFFFL) * dl + carry;
            rmag[rstart--] = (int)product;
            carry = product >>> 32;
            --i;
        }
        rmag[rstart] = (int)carry;
        if (dh != 0L) {
            carry = 0L;
            rstart = rmag.length - 2;
            i = xlen - 1;
            while (i >= 0) {
                product = ((long)value[i] & 0xFFFFFFFFL) * dh + ((long)rmag[rstart] & 0xFFFFFFFFL) + carry;
                rmag[rstart--] = (int)product;
                carry = product >>> 32;
                --i;
            }
            rmag[0] = (int)carry;
        }
        if (carry == 0L) {
            rmag = Arrays.copyOfRange(rmag, 1, rmag.length);
        }
        return new BigInteger(rmag, rsign);
    }

    private int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, @Nullable int[] z) {
        int xstart = xlen - 1;
        int ystart = ylen - 1;
        if (z == null || z.length < xlen + ylen) {
            z = new int[xlen + ylen];
        }
        long carry = 0L;
        int j = ystart;
        int k = ystart + 1 + xstart;
        while (j >= 0) {
            long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
            z[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        z[xstart] = (int)carry;
        int i = xstart - 1;
        while (i >= 0) {
            carry = 0L;
            int j2 = ystart;
            int k2 = ystart + 1 + i;
            while (j2 >= 0) {
                long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z[k2] & 0xFFFFFFFFL) + carry;
                z[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            z[i] = (int)carry;
            --i;
        }
        return z;
    }

    private static BigInteger multiplyKaratsuba(BigInteger x, BigInteger y) {
        int xlen = x.mag.length;
        int ylen = y.mag.length;
        int half = (Math.max(xlen, ylen) + 1) / 2;
        BigInteger xl = x.getLower(half);
        BigInteger xh = x.getUpper(half);
        BigInteger yl = y.getLower(half);
        BigInteger yh = y.getUpper(half);
        BigInteger p1 = xh.multiply(yh);
        BigInteger p2 = xl.multiply(yl);
        BigInteger p3 = xh.add(xl).multiply(yh.add(yl));
        BigInteger result = p1.shiftLeft(32 * half).add(p3.subtract(p1).subtract(p2)).shiftLeft(32 * half).add(p2);
        if (x.signum != y.signum) {
            return result.negate();
        }
        return result;
    }

    private static BigInteger multiplyToomCook3(BigInteger a, BigInteger b) {
        int alen = a.mag.length;
        int blen = b.mag.length;
        int largest = Math.max(alen, blen);
        int k = (largest + 2) / 3;
        int r = largest - 2 * k;
        BigInteger a2 = a.getToomSlice(k, r, 0, largest);
        BigInteger a1 = a.getToomSlice(k, r, 1, largest);
        BigInteger a0 = a.getToomSlice(k, r, 2, largest);
        BigInteger b2 = b.getToomSlice(k, r, 0, largest);
        BigInteger b1 = b.getToomSlice(k, r, 1, largest);
        BigInteger b0 = b.getToomSlice(k, r, 2, largest);
        BigInteger v0 = a0.multiply(b0);
        BigInteger da1 = a2.add(a0);
        BigInteger db1 = b2.add(b0);
        BigInteger vm1 = da1.subtract(a1).multiply(db1.subtract(b1));
        da1 = da1.add(a1);
        db1 = db1.add(b1);
        BigInteger v1 = da1.multiply(db1);
        BigInteger v2 = da1.add(a2).shiftLeft(1).subtract(a0).multiply(db1.add(b2).shiftLeft(1).subtract(b0));
        BigInteger vinf = a2.multiply(b2);
        BigInteger t2 = v2.subtract(vm1).exactDivideBy3();
        BigInteger tm1 = v1.subtract(vm1).shiftRight(1);
        BigInteger t1 = v1.subtract(v0);
        t2 = t2.subtract(t1).shiftRight(1);
        t1 = t1.subtract(tm1).subtract(vinf);
        t2 = t2.subtract(vinf.shiftLeft(1));
        tm1 = tm1.subtract(t2);
        int ss = k * 32;
        BigInteger result = vinf.shiftLeft(ss).add(t2).shiftLeft(ss).add(t1).shiftLeft(ss).add(tm1).shiftLeft(ss).add(v0);
        if (a.signum != b.signum) {
            return result.negate();
        }
        return result;
    }

    private BigInteger getToomSlice(int lowerSize, int upperSize, int slice, int fullsize) {
        int end;
        int start;
        int len = this.mag.length;
        int offset = fullsize - len;
        if (slice == 0) {
            start = 0 - offset;
            end = upperSize - 1 - offset;
        } else {
            start = upperSize + (slice - 1) * lowerSize - offset;
            end = start + lowerSize - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            return ZERO;
        }
        int sliceSize = end - start + 1;
        if (sliceSize <= 0) {
            return ZERO;
        }
        if (start == 0 && sliceSize >= len) {
            return this.abs();
        }
        int[] intSlice = new int[sliceSize];
        System.arraycopy(this.mag, start, intSlice, 0, sliceSize);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(intSlice), 1);
    }

    private BigInteger exactDivideBy3() {
        int len = this.mag.length;
        int[] result = new int[len];
        long borrow = 0L;
        int i = len - 1;
        while (i >= 0) {
            long x = (long)this.mag[i] & 0xFFFFFFFFL;
            long w = x - borrow;
            borrow = borrow > x ? 1L : 0L;
            long q = w * 0xAAAAAAABL & 0xFFFFFFFFL;
            result[i] = (int)q;
            if (q >= 0x55555556L) {
                ++borrow;
                if (q >= 0xAAAAAAABL) {
                    ++borrow;
                }
            }
            --i;
        }
        result = BigInteger.trustedStripLeadingZeroInts(result);
        return new BigInteger(result, this.signum);
    }

    private BigInteger getLower(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return this.abs();
        }
        int[] lowerInts = new int[n];
        System.arraycopy(this.mag, len - n, lowerInts, 0, n);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(lowerInts), 1);
    }

    private BigInteger getUpper(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return ZERO;
        }
        int upperLen = len - n;
        int[] upperInts = new int[upperLen];
        System.arraycopy(this.mag, 0, upperInts, 0, upperLen);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(upperInts), 1);
    }

    private BigInteger square() {
        if (this.signum == 0) {
            return ZERO;
        }
        int len = this.mag.length;
        if (len < 128) {
            int[] z = BigInteger.squareToLen(this.mag, len, null);
            return new BigInteger(BigInteger.trustedStripLeadingZeroInts(z), 1);
        }
        if (len < 216) {
            return this.squareKaratsuba();
        }
        return this.squareToomCook3();
    }

    private static final int[] squareToLen(int[] x, int len, @Nullable int[] z) {
        int zlen = len << 1;
        if (z == null || z.length < zlen) {
            z = new int[zlen];
        }
        int lastProductLowWord = 0;
        int j = 0;
        int i = 0;
        while (j < len) {
            long piece = (long)x[j] & 0xFFFFFFFFL;
            long product = piece * piece;
            z[i++] = lastProductLowWord << 31 | (int)(product >>> 33);
            z[i++] = (int)(product >>> 1);
            lastProductLowWord = (int)product;
            ++j;
        }
        int i2 = len;
        int offset = 1;
        while (i2 > 0) {
            int t = x[i2 - 1];
            t = BigInteger.mulAdd(z, x, offset, i2 - 1, t);
            BigInteger.addOne(z, offset - 1, i2, t);
            --i2;
            offset += 2;
        }
        BigInteger.primitiveLeftShift(z, zlen, 1);
        int n = zlen - 1;
        z[n] = z[n] | x[len - 1] & 1;
        return z;
    }

    private BigInteger squareKaratsuba() {
        int half = (this.mag.length + 1) / 2;
        BigInteger xl = this.getLower(half);
        BigInteger xh = this.getUpper(half);
        BigInteger xhs = xh.square();
        BigInteger xls = xl.square();
        return xhs.shiftLeft(half * 32).add(xl.add(xh).square().subtract(xhs.add(xls))).shiftLeft(half * 32).add(xls);
    }

    private BigInteger squareToomCook3() {
        int len = this.mag.length;
        int k = (len + 2) / 3;
        int r = len - 2 * k;
        BigInteger a2 = this.getToomSlice(k, r, 0, len);
        BigInteger a1 = this.getToomSlice(k, r, 1, len);
        BigInteger a0 = this.getToomSlice(k, r, 2, len);
        BigInteger v0 = a0.square();
        BigInteger da1 = a2.add(a0);
        BigInteger vm1 = da1.subtract(a1).square();
        da1 = da1.add(a1);
        BigInteger v1 = da1.square();
        BigInteger vinf = a2.square();
        BigInteger v2 = da1.add(a2).shiftLeft(1).subtract(a0).square();
        BigInteger t2 = v2.subtract(vm1).exactDivideBy3();
        BigInteger tm1 = v1.subtract(vm1).shiftRight(1);
        BigInteger t1 = v1.subtract(v0);
        t2 = t2.subtract(t1).shiftRight(1);
        t1 = t1.subtract(tm1).subtract(vinf);
        t2 = t2.subtract(vinf.shiftLeft(1));
        tm1 = tm1.subtract(t2);
        int ss = k * 32;
        return vinf.shiftLeft(ss).add(t2).shiftLeft(ss).add(t1).shiftLeft(ss).add(tm1).shiftLeft(ss).add(v0);
    }

    BigInteger divide(BigInteger val) {
        return this.divideKnuth(val);
    }

    private BigInteger divideKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        a.divideKnuth(b, q, false);
        return q.toBigInteger(this.signum * val.signum);
    }

    BigInteger[] divideAndRemainder(BigInteger val) {
        return this.divideAndRemainderKnuth(val);
    }

    private BigInteger[] divideAndRemainderKnuth(BigInteger val) {
        BigInteger[] result = new BigInteger[2];
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        MutableBigInteger r = a.divideKnuth(b, q);
        result[0] = q.toBigInteger(this.signum == val.signum ? 1 : -1);
        result[1] = r.toBigInteger(this.signum);
        return result;
    }

    static int bitLengthForInt(int n) {
        return 32 - IntegerHelper.numberOfLeadingZeros(n);
    }

    static void primitiveLeftShift(int[] a, int len, int n) {
        if (len == 0 || n == 0) {
            return;
        }
        int n2 = 32 - n;
        int i = 0;
        int c = a[i];
        int m = i + len - 1;
        while (i < m) {
            int b = c;
            c = a[i + 1];
            a[i] = b << n | c >>> n2;
            ++i;
        }
        int n3 = len - 1;
        a[n3] = a[n3] << n;
    }

    BigInteger abs() {
        return this.signum >= 0 ? this : this.negate();
    }

    BigInteger negate() {
        return new BigInteger(this.mag, -this.signum);
    }

    static int mulAdd(int[] out, int[] in, int offset, int len, int k) {
        long kLong = (long)k & 0xFFFFFFFFL;
        long carry = 0L;
        offset = out.length - offset - 1;
        int j = len - 1;
        while (j >= 0) {
            long product = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out[offset] & 0xFFFFFFFFL) + carry;
            out[offset--] = (int)product;
            carry = product >>> 32;
            --j;
        }
        return (int)carry;
    }

    /*
     * Unable to fully structure code
     */
    static int addOne(int[] a, int offset, int mlen, int carry) {
        offset = a.length - 1 - mlen - offset;
        t = ((long)a[offset] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
        a[offset] = (int)t;
        if (t >>> 32 != 0L) ** GOTO lbl12
        return 0;
lbl-1000:
        // 1 sources

        {
            if (--offset < 0) {
                return 1;
            }
            v0 = offset;
            a[v0] = a[v0] + 1;
            if (a[offset] == 0) continue;
            return 0;
lbl12:
            // 2 sources

            ** while (--mlen >= 0)
        }
lbl13:
        // 1 sources

        return 1;
    }

    BigInteger shiftLeft(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return new BigInteger(BigInteger.shiftLeft(this.mag, n), this.signum);
        }
        if (n == 0) {
            return this;
        }
        return this.shiftRightImpl(-n);
    }

    private static int[] shiftLeft(int[] mag, int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = mag.length;
        int[] newMag = null;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            System.arraycopy(mag, 0, newMag, 0, magLen);
        } else {
            int i = 0;
            int nBits2 = 32 - nBits;
            int highBits = mag[0] >>> nBits2;
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen + nInts];
            }
            int j = 0;
            while (j < magLen - 1) {
                newMag[i++] = mag[j++] << nBits | mag[j] >>> nBits2;
            }
            newMag[i] = mag[j] << nBits;
        }
        return newMag;
    }

    BigInteger shiftRight(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return this.shiftRightImpl(n);
        }
        if (n == 0) {
            return this;
        }
        return new BigInteger(BigInteger.shiftLeft(this.mag, -n), this.signum);
    }

    private BigInteger shiftRightImpl(int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this.mag.length;
        int[] newMag = null;
        if (nInts >= magLen) {
            return this.signum >= 0 ? ZERO : BigInteger.valueOf(-1L);
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            newMag = Arrays.copyOf(this.mag, newMagLen);
        } else {
            int i = 0;
            int highBits = this.mag[0] >>> nBits;
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            int j = 0;
            while (j < magLen - nInts - 1) {
                newMag[i++] = this.mag[j++] << nBits2 | this.mag[j] >>> nBits;
            }
        }
        if (this.signum < 0) {
            boolean onesLost = false;
            int i = magLen - 1;
            int j = magLen - nInts;
            while (i >= j && !onesLost) {
                onesLost = this.mag[i] != 0;
                --i;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this.mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new BigInteger(newMag, this.signum);
    }

    int[] javaIncrement(int[] val) {
        int lastSum = 0;
        int i = val.length - 1;
        while (i >= 0 && lastSum == 0) {
            int n = i--;
            int n2 = val[n] + 1;
            val[n] = n2;
            lastSum = n2;
        }
        if (lastSum == 0) {
            val = new int[val.length + 1];
            val[0] = 1;
        }
        return val;
    }

    @Override
    public int compareTo(BigInteger val) {
        throw new UnsupportedOperationException();
    }

    final int compareMagnitude(BigInteger val) {
        int[] m1 = this.mag;
        int len1 = m1.length;
        int[] m2 = val.mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        int i = 0;
        while (i < len1) {
            int a = m1[i];
            int b = m2[i];
            if (a != b) {
                return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
            }
            ++i;
        }
        return 0;
    }

    final int compareMagnitude(long val) {
        int highWord;
        assert (val != Long.MIN_VALUE);
        int[] m1 = this.mag;
        int len = m1.length;
        if (len > 2) {
            return 1;
        }
        if (val < 0L) {
            val = -val;
        }
        if ((highWord = (int)(val >>> 32)) == 0) {
            if (len < 1) {
                return -1;
            }
            if (len > 1) {
                return 1;
            }
            int a = m1[0];
            int b = (int)val;
            if (a != b) {
                return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
            }
            return 0;
        }
        if (len < 2) {
            return -1;
        }
        int a = m1[0];
        int b = highWord;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        a = m1[1];
        b = (int)val;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)x;
        if (xInt.signum != this.signum) {
            return false;
        }
        int[] m = this.mag;
        int len = m.length;
        int[] xm = xInt.mag;
        if (len != xm.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (xm[i] != m[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.mag.length) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.mag[i] & 0xFFFFFFFFL));
            ++i;
        }
        return hashCode * this.signum;
    }

    @Override
    public int intValue() {
        int result = 0;
        result = this.getInt(0);
        return result;
    }

    @Override
    public long longValue() {
        long result = 0L;
        int i = 1;
        while (i >= 0) {
            result = (result << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
            --i;
        }
        return result;
    }

    private int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.mag.length) {
            return this.signum < 0 ? -1 : 0;
        }
        int magInt = this.mag[this.mag.length - n - 1];
        return this.signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private int firstNonzeroIntNum() {
        int mlen = this.mag.length;
        int i = mlen - 1;
        while (i >= 0 && this.mag[i] == 0) {
            --i;
        }
        return mlen - i - 1;
    }

    private static int[] trustedStripLeadingZeroInts(int[] val) {
        int vlen = val.length;
        int keep = 0;
        while (keep < vlen && val[keep] == 0) {
            ++keep;
        }
        return keep == 0 ? val : Arrays.copyOfRange(val, keep, vlen);
    }

    int bitLength() {
        int n;
        int[] m = this.mag;
        int len = m.length;
        if (len == 0) {
            n = 0;
        } else {
            int magBitLength = (len - 1 << 5) + BigInteger.bitLengthForInt(this.mag[0]);
            if (this.signum < 0) {
                boolean pow2 = IntegerHelper.bitCount(this.mag[0]) == 1;
                int i = 1;
                while (i < len && pow2) {
                    pow2 = this.mag[i] == 0;
                    ++i;
                }
                n = pow2 ? magBitLength - 1 : magBitLength;
            } else {
                n = magBitLength;
            }
        }
        return n;
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float floatValue() {
        throw new UnsupportedOperationException();
    }
}

