/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.net;

import android.net.ConnectivityManager;
import android.net.Network;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OnNetworkStateChanged
extends ConnectivityManager.NetworkCallback {
    private static final Logger LOGGER = Logger.getLogger("OnNetworkStateChanged");

    public OnNetworkStateChanged() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Listening on network interface changes");
        }
    }

    public void onAvailable(Network network) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Network UP");
        }
        this.listNetworkInterfaces();
    }

    public void onLost(Network network) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Network Down");
        }
        this.listNetworkInterfaces();
    }

    private void listNetworkInterfaces() {
        block5: {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Available Network interfaces:");
                boolean netifFound = false;
                try {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface netif = interfaces.nextElement();
                        if (!this.isValidNetworkInterface(netif)) continue;
                        netifFound = true;
                        this.logInterfaceInformation(netif);
                    }
                    if (!netifFound) {
                        LOGGER.info("(none)");
                    }
                }
                catch (SocketException e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block5;
                    LOGGER.log(Level.FINEST, e.getMessage(), e);
                }
            }
        }
    }

    private boolean isValidNetworkInterface(NetworkInterface netif) {
        try {
            return netif.isUp() && !netif.isLoopback();
        }
        catch (SocketException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
            return false;
        }
    }

    private void logInterfaceInformation(NetworkInterface netif) throws SocketException {
        LOGGER.info("Network Name: " + netif.getName());
        LOGGER.info("--- MTU: " + netif.getMTU());
        Enumeration<InetAddress> addresses = netif.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            LOGGER.info("--- IP Address: " + address.getHostAddress());
        }
    }
}

