/*
 * Decompiled with CFR 0.152.
 */
package java.util;

final class DualPivotQuicksort {
    private static final int MAX_RUN_COUNT = 67;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    public static void sort(int[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(int[] a, int left, int right) {
        int[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    int t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new int[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new int[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            int[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(int[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = pivot1;
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (ak >= pivot) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = pivot;
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    public static void sort(long[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(long[] a, int left, int right) {
        long[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    long t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new long[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new long[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            long[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(long[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = pivot1;
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (ak >= pivot) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = pivot;
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    public static void sort(short[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(short[] a, int left, int right) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                int n = a[i] - Short.MIN_VALUE;
                count[n] = count[n] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                short value = (short)(i + Short.MIN_VALUE);
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a, left, right);
        }
    }

    private static void doSort(short[] a, int left, int right) {
        short[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    short t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new short[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new short[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            short[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(short[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = pivot1;
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (ak >= pivot) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = pivot;
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    public static void sort(char[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(char[] a, int left, int right) {
        if (right - left > 3200) {
            int[] count = new int[65536];
            int i = left - 1;
            while (++i <= right) {
                char c = a[i];
                count[c] = count[c] + 1;
            }
            i = 65536;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                char value = (char)i;
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            DualPivotQuicksort.doSort(a, left, right);
        }
    }

    private static void doSort(char[] a, int left, int right) {
        char[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    char t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new char[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new char[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            char[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(char[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = pivot1;
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (ak >= pivot) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = pivot;
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    public static void sort(byte[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(byte[] a, int left, int right) {
        if (right - left > 29) {
            int[] count = new int[256];
            int i = left - 1;
            while (++i <= right) {
                int n = a[i] - -128;
                count[n] = count[n] + 1;
            }
            i = 256;
            int k = right + 1;
            while (k > left) {
                while (count[--i] == 0) {
                }
                byte value = (byte)(i + -128);
                int s = count[i];
                do {
                    a[--k] = value;
                } while (--s > 0);
            }
        } else {
            int i;
            int j = i = left;
            while (i < right) {
                byte ai = a[i + 1];
                while (ai < a[j]) {
                    a[j + 1] = a[j];
                    if (j-- == left) break;
                }
                a[j + 1] = ai;
                j = ++i;
            }
        }
    }

    public static void sort(float[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(float[] a, int left, int right) {
        while (left <= right && Float.isNaN(a[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            float ak = a[k];
            if (ak == ak) continue;
            a[k] = a[right];
            a[right] = ak;
            --right;
        }
        DualPivotQuicksort.doSort(a, left, right);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            float middleValue = a[middle];
            if (middleValue < 0.0f) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Float.floatToRawIntBits(a[left]) < 0) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right) {
            float ak = a[k2];
            if (ak != 0.0f) break;
            if (Float.floatToRawIntBits(ak) >= 0) continue;
            a[k2] = 0.0f;
            a[++p] = -0.0f;
        }
    }

    private static void doSort(float[] a, int left, int right) {
        float[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    float t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new float[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new float[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            float[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(float[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = a[great];
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (!(ak < pivot)) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }

    public static void sort(double[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(double[] a, int left, int right) {
        while (left <= right && Double.isNaN(a[right])) {
            --right;
        }
        int k = right;
        while (--k >= left) {
            double ak = a[k];
            if (ak == ak) continue;
            a[k] = a[right];
            a[right] = ak;
            --right;
        }
        DualPivotQuicksort.doSort(a, left, right);
        int hi = right;
        while (left < hi) {
            int middle = left + hi >>> 1;
            double middleValue = a[middle];
            if (middleValue < 0.0) {
                left = middle + 1;
                continue;
            }
            hi = middle;
        }
        while (left <= right && Double.doubleToRawLongBits(a[left]) < 0L) {
            ++left;
        }
        int k2 = left;
        int p = left - 1;
        while (++k2 <= right) {
            double ak = a[k2];
            if (ak != 0.0) break;
            if (Double.doubleToRawLongBits(ak) >= 0L) continue;
            a[k2] = 0.0;
            a[++p] = -0.0;
        }
    }

    private static void doSort(double[] a, int left, int right) {
        double[] b;
        if (right - left < 286) {
            DualPivotQuicksort.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    double t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    DualPivotQuicksort.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                DualPivotQuicksort.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new double[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new double[a.length];
        }
        while (count > 1) {
            int last = 0;
            int k2 = 0 + 2;
            while (k2 <= count) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
                k2 += 2;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            double[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void sort(double[] a, int left, int right, boolean leftmost) {
        block41: {
            block40: {
                length = right - left + 1;
                if (length < 47) {
                    if (leftmost) {
                        j = i = left;
                        while (i < right) {
                            ai = a[i + 1];
                            while (ai < a[j]) {
                                a[j + 1] = a[j];
                                if (j-- == left) break;
                            }
                            a[j + 1] = ai;
                            j = ++i;
                        }
                    } else {
                        do {
                            if (left < right) continue;
                            return;
                        } while (a[++left] >= a[left - 1]);
                        k = left;
                        while (++left <= right) {
                            a1 = a[k];
                            a2 = a[left];
                            if (a1 < a2) {
                                a2 = a1;
                                a1 = a[left];
                            }
                            while (a1 < a[--k]) {
                                a[k + 2] = a[k];
                            }
                            a[++k + 1] = a1;
                            while (a2 < a[--k]) {
                                a[k + 1] = a[k];
                            }
                            a[k + 1] = a2;
                            k = ++left;
                        }
                        last = a[right];
                        while (last < a[--right]) {
                            a[right + 1] = a[right];
                        }
                        a[right + 1] = last;
                    }
                    return;
                }
                seventh = (length >> 3) + (length >> 6) + 1;
                e3 = left + right >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                less = left;
                great = right;
                if (a[e1] == a[e2] || a[e2] == a[e3] || a[e3] == a[e4] || a[e4] == a[e5]) break block40;
                pivot1 = a[e2];
                pivot2 = a[e4];
                a[e2] = a[left];
                a[e4] = a[right];
                while (a[++less] < pivot1) {
                }
                while (a[--great] > pivot2) {
                }
                k = less - 1;
                block9: while (++k <= great) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    while (a[great] > pivot2) {
                        if (great-- == k) break block9;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                a[left] = a[less - 1];
                a[less - 1] = pivot1;
                a[right] = a[great + 1];
                a[great + 1] = pivot2;
                DualPivotQuicksort.sort(a, left, less - 2, leftmost);
                DualPivotQuicksort.sort(a, great + 2, right, false);
                if (less < e1 && e5 < great) {
                    while (a[less] == pivot1) {
                        ++less;
                    }
                    while (a[great] == pivot2) {
                        --great;
                    }
                    k = less - 1;
                    block13: while (++k <= great) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[less];
                            a[less] = ak;
                            ++less;
                            continue;
                        }
                        if (ak != pivot2) continue;
                        while (a[great] == pivot2) {
                            if (great-- == k) break block13;
                        }
                        if (a[great] == pivot1) {
                            a[k] = a[less];
                            a[less] = a[great];
                            ++less;
                        } else {
                            a[k] = a[great];
                        }
                        a[great] = ak;
                        --great;
                    }
                }
                DualPivotQuicksort.sort(a, less, great, false);
                break block41;
            }
            pivot = a[e3];
            k = less;
            while (k <= great) {
                block42: {
                    if (a[k] == pivot) break block42;
                    ak = a[k];
                    if (!(ak < pivot)) ** GOTO lbl162
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    break block42;
lbl-1000:
                    // 1 sources

                    {
                        --great;
lbl162:
                        // 2 sources

                        ** while (a[great] > pivot)
                    }
lbl163:
                    // 1 sources

                    if (a[great] < pivot) {
                        a[k] = a[less];
                        a[less] = a[great];
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
                ++k;
            }
            DualPivotQuicksort.sort(a, left, less - 1, leftmost);
            DualPivotQuicksort.sort(a, great + 1, right, false);
        }
    }
}

