/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    @Nullable
    private PipedInputStream sink;

    public PipedOutputStream(PipedInputStream snk) throws IOException {
        this.connect(snk);
    }

    public PipedOutputStream() {
    }

    public synchronized void connect(PipedInputStream snk) throws IOException {
        if (snk.connected || this.sink != null) {
            throw new IOException("Already connected");
        }
        this.sink = snk;
        snk.in = -1;
        snk.out = 0;
        snk.connected = true;
    }

    @Override
    public void write(int b) throws IOException {
        PipedInputStream sink = this.sink;
        if (sink == null) {
            throw new IOException("Pipe not connected");
        }
        sink.receive(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        PipedInputStream sink = this.sink;
        if (sink == null) {
            throw new IOException("Pipe not connected");
        }
        int length = b.length;
        if (off < 0 || off > length || len < 0 || off + len > length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        sink.receive(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        PipedInputStream sink = this.sink;
        if (sink != null) {
            PipedInputStream pipedInputStream = sink;
            synchronized (pipedInputStream) {
                sink.notifyAll();
            }
        }
    }

    @Override
    public void close() throws IOException {
        PipedInputStream sink = this.sink;
        if (sink != null) {
            sink.receivedLast();
        }
    }
}

