/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web;

import ej.rest.web.AbstractContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class ChunkedContent
extends AbstractContent {
    private static final int BUFFER_SIZE = 4096;
    private int chunkSize = 4096;
    private final InputStream in;
    private final String mime;

    public ChunkedContent(String mime, InputStream in, int chunkSize) {
        this.in = in;
        this.mime = mime;
        if (chunkSize > 0) {
            this.chunkSize = chunkSize;
        }
    }

    @Override
    public void writeHeader(OutputStream os) throws IOException {
        os.write(this.ascii("Content-Type: " + this.mime + "\r\n"));
        os.write(this.ascii("Transfer-Encoding: chunked\r\n"));
    }

    @Override
    public void writeContent(OutputStream os) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = this.in.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    @Override
    protected void addContent(URLConnection con) throws IOException {
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setChunkedStreamingMode(this.chunkSize);
        }
        con.setDoOutput(true);
        con.addRequestProperty("Content-Type", this.mime);
        con.addRequestProperty("Transfer-Encoding", "chunked");
        OutputStream os = con.getOutputStream();
        this.writeContent(os);
        os.close();
    }
}

