/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.json;

import ej.rest.util.Tool;
import java.util.Enumeration;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.util.XML;
import org.json.me.util.XMLTokener;

public class JSONML {
    private static Object parse(XMLTokener x, boolean arrayForm, JSONArray ja) throws JSONException {
        String closeTag = null;
        JSONArray newja = null;
        JSONObject newjo = null;
        String tagName = null;
        while (true) {
            Object token;
            if ((token = x.nextContent()) == XML.LT) {
                token = x.nextToken();
                if (token instanceof Character) {
                    if (token == XML.SLASH) {
                        token = x.nextToken();
                        if (!(token instanceof String)) {
                            throw new JSONException("Expected a closing name instead of '" + token + "'.");
                        }
                        if (x.nextToken() != XML.GT) {
                            throw x.syntaxError("Misshaped close tag");
                        }
                        return token;
                    }
                    if (token == XML.BANG) {
                        char c = x.next();
                        if (c == '-') {
                            if (x.next() == '-') {
                                x.skipPast("-->");
                            }
                            x.back();
                            continue;
                        }
                        if (c == '[') {
                            token = x.nextToken();
                            if (token.equals("CDATA") && x.next() == '[') {
                                if (ja == null) continue;
                                ja.put((Object)x.nextCDATA());
                                continue;
                            }
                            throw x.syntaxError("Expected 'CDATA['");
                        }
                        int i = 1;
                        do {
                            if ((token = x.nextMeta()) == null) {
                                throw x.syntaxError("Missing '>' after '<!'.");
                            }
                            if (token == XML.LT) {
                                ++i;
                                continue;
                            }
                            if (token != XML.GT) continue;
                            --i;
                        } while (i > 0);
                        continue;
                    }
                    if (token == XML.QUEST) {
                        x.skipPast("?>");
                        continue;
                    }
                    throw x.syntaxError("Misshaped tag");
                }
                if (!(token instanceof String)) {
                    throw x.syntaxError("Bad tagName '" + token + "'.");
                }
                tagName = (String)token;
                newja = new JSONArray();
                newjo = new JSONObject();
                if (arrayForm) {
                    newja.put((Object)tagName);
                    if (ja != null) {
                        ja.put((Object)newja);
                    }
                } else {
                    newjo.put("tagName", (Object)tagName);
                    if (ja != null) {
                        ja.put((Object)newjo);
                    }
                }
                token = null;
                while (true) {
                    if (token == null) {
                        token = x.nextToken();
                    }
                    if (token == null) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (!(token instanceof String)) break;
                    String attribute = (String)token;
                    if (!(arrayForm || attribute != "tagName" && attribute != "childNode")) {
                        throw x.syntaxError("Reserved attribute.");
                    }
                    token = x.nextToken();
                    if (token == XML.EQ) {
                        token = x.nextToken();
                        if (!(token instanceof String)) {
                            throw x.syntaxError("Missing value");
                        }
                        newjo.accumulate(attribute, Tool.stringToValue((String)token));
                        token = null;
                        continue;
                    }
                    newjo.accumulate(attribute, (Object)"");
                }
                if (arrayForm && newjo.length() > 0) {
                    newja.put((Object)newjo);
                }
                if (token == XML.SLASH) {
                    if (x.nextToken() != XML.GT) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (ja != null) continue;
                    if (arrayForm) {
                        return newja;
                    }
                    return newjo;
                }
                if (token != XML.GT) {
                    throw x.syntaxError("Misshaped tag");
                }
                closeTag = (String)JSONML.parse(x, arrayForm, newja);
                if (closeTag == null) continue;
                if (!closeTag.equals(tagName)) {
                    throw x.syntaxError("Mismatched '" + tagName + "' and '" + closeTag + "'");
                }
                tagName = null;
                if (!arrayForm && newja.length() > 0) {
                    newjo.put("childNodes", (Object)newja);
                }
                if (ja != null) continue;
                if (arrayForm) {
                    return newja;
                }
                return newjo;
            }
            if (ja == null) continue;
            ja.put(token instanceof String ? Tool.stringToValue((String)token) : token);
        }
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return JSONML.toJSONArray(new XMLTokener(string));
    }

    public static JSONArray toJSONArray(XMLTokener x) throws JSONException {
        return (JSONArray)JSONML.parse(x, true, null);
    }

    public static JSONObject toJSONObject(XMLTokener x) throws JSONException {
        return (JSONObject)JSONML.parse(x, false, null);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return JSONML.toJSONObject(new XMLTokener(string));
    }

    public static String toString(JSONArray ja) throws JSONException {
        int i;
        StringBuffer sb = new StringBuffer();
        String tagName = ja.getString(0);
        Tool.noSpace(tagName);
        tagName = XML.escape((String)tagName);
        sb.append('<');
        sb.append(tagName);
        Object e = ja.opt(1);
        if (e instanceof JSONObject) {
            i = 2;
            JSONObject jo = (JSONObject)e;
            Enumeration keys = jo.keys();
            while (keys.hasMoreElements()) {
                String k = keys.nextElement().toString();
                Tool.noSpace(k);
                String v = jo.optString(k);
                if (v == null) continue;
                sb.append(' ');
                sb.append(XML.escape((String)k));
                sb.append('=');
                sb.append('\"');
                sb.append(XML.escape((String)v));
                sb.append('\"');
            }
        } else {
            i = 1;
        }
        int length = ja.length();
        if (i >= length) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            do {
                e = ja.get(i);
                ++i;
                if (e == null) continue;
                if (e instanceof String) {
                    sb.append(XML.escape((String)e.toString()));
                    continue;
                }
                if (e instanceof JSONObject) {
                    sb.append(JSONML.toString((JSONObject)e));
                    continue;
                }
                if (!(e instanceof JSONArray)) continue;
                sb.append(JSONML.toString((JSONArray)e));
            } while (i < length);
            sb.append('<');
            sb.append('/');
            sb.append(tagName);
            sb.append('>');
        }
        return sb.toString();
    }

    public static String toString(JSONObject jo) throws JSONException {
        StringBuffer sb = new StringBuffer();
        String tagName = jo.optString("tagName");
        if (tagName == null) {
            return XML.escape((String)jo.toString());
        }
        Tool.noSpace(tagName);
        tagName = XML.escape((String)tagName);
        sb.append('<');
        sb.append(tagName);
        Enumeration keys = jo.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement().toString();
            if (k.equals("tagName") || k.equals("childNodes")) continue;
            Tool.noSpace(k);
            String v = jo.optString(k);
            if (v == null) continue;
            sb.append(' ');
            sb.append(XML.escape((String)k));
            sb.append('=');
            sb.append('\"');
            sb.append(XML.escape((String)v));
            sb.append('\"');
        }
        JSONArray ja = jo.optJSONArray("childNodes");
        if (ja == null) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            int len = ja.length();
            int i = 0;
            while (i < len) {
                Object e = ja.get(i);
                if (e != null) {
                    if (e instanceof String) {
                        sb.append(XML.escape((String)e.toString()));
                    } else if (e instanceof JSONObject) {
                        sb.append(JSONML.toString((JSONObject)e));
                    } else if (e instanceof JSONArray) {
                        sb.append(JSONML.toString((JSONArray)e));
                    }
                }
                ++i;
            }
            sb.append('<');
            sb.append('/');
            sb.append(tagName);
            sb.append('>');
        }
        return sb.toString();
    }
}

