/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.io;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedMessageBodyInputStream
extends InputStream {
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final int STATE_CONSUME_CHUNK = 2;
    private static final int STATE_END = 3;
    private static final int STATE_START = 1;
    private boolean closed = false;
    private final InputStream is;
    private int remainingBytes;
    private int state;

    public ChunkedMessageBodyInputStream(InputStream is) {
        this.is = is;
        this.state = 1;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return Math.min(this.is.available(), this.remainingBytes);
    }

    private void checkPrematureEOF(int i) throws IOException {
        if (i == -1) {
            this.closed = true;
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.state != 3) {
            byte[] buf = new byte[512];
            while (this.initChunk()) {
                int result = this.is.read(buf, 0, Math.min(512, this.remainingBytes));
                this.checkPrematureEOF(result);
                this.remainingBytes -= result;
            }
        }
        this.closed = true;
    }

    private boolean initChunk() throws IOException {
        if (this.state == 3) {
            return false;
        }
        if (this.remainingBytes == 0) {
            int b;
            if (this.state == 2) {
                b = this.is.read();
                this.checkPrematureEOF(b);
                b = this.is.read();
                this.checkPrematureEOF(b);
            }
            int size = 0;
            boolean hasExtension = false;
            while (true) {
                b = this.is.read();
                this.checkPrematureEOF(b);
                if (b == 59) {
                    hasExtension = true;
                    break;
                }
                if (b == 13) break;
                size = (size << 4) + Character.digit((char)b, 16);
            }
            if (hasExtension) {
                do {
                    b = this.is.read();
                    this.checkPrematureEOF(b);
                } while (b != 13);
            }
            b = this.is.read();
            this.checkPrematureEOF(b);
            this.remainingBytes = size;
            if (size == 0) {
                while (true) {
                    b = this.is.read();
                    this.checkPrematureEOF(b);
                    if (b == 13) {
                        this.state = 3;
                        return false;
                    }
                    do {
                        b = this.is.read();
                        this.checkPrematureEOF(b);
                    } while (b != 13);
                    b = this.is.read();
                    this.checkPrematureEOF(b);
                }
            }
            this.state = 2;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.initChunk()) {
            return -1;
        }
        int result = this.is.read();
        this.checkPrematureEOF(result);
        --this.remainingBytes;
        return result;
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.initChunk()) {
            return -1;
        }
        int nbToRead = length <= this.remainingBytes ? length : this.remainingBytes;
        int result = this.is.read(data, offset, nbToRead);
        this.checkPrematureEOF(result);
        this.remainingBytes -= result;
        return result;
    }
}

