/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.io;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedMessageBodyOutputStream
extends OutputStream {
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final int PENDING_BYTE_LENGTH = 32;
    private static final int HEXA = 16;
    private boolean closed = false;
    private int nbPendingBytes = 0;
    private final OutputStream os;
    private final byte[] pendingBytes;

    public ChunkedMessageBodyOutputStream(OutputStream os) {
        this.os = os;
        this.pendingBytes = new byte[32];
    }

    @Override
    public final void close() throws IOException {
        this.writePendingBytes();
        this.os.write(48);
        this.os.write(CRLF);
        this.os.write(CRLF);
        this.os.flush();
        this.closed = true;
    }

    @Override
    public final void flush() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.writePendingBytes();
        this.os.flush();
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.writePendingBytes();
        this.writeChunk(b, off, len);
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.pendingBytes[this.nbPendingBytes] = (byte)b;
        ++this.nbPendingBytes;
        if (this.nbPendingBytes == 32) {
            this.writePendingBytes();
        }
    }

    private void writeChunk(byte[] b, int off, int len) throws IOException {
        this.os.write(Integer.toString(len, 16).getBytes());
        this.os.write(CRLF);
        this.os.write(b, off, len);
        this.os.write(CRLF);
    }

    private void writePendingBytes() throws IOException {
        if (this.nbPendingBytes == 0) {
            return;
        }
        this.writeChunk(this.pendingBytes, 0, this.nbPendingBytes);
        this.nbPendingBytes = 0;
    }
}

