/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.bluetooth.util.BluetoothPayloadUtil;

public class BluetoothPayloadBuilder {
    private byte[] payload = new byte[0];

    public BluetoothPayloadBuilder() {
    }

    public BluetoothPayloadBuilder(byte type, byte[] value) {
        this();
        this.append(type, value);
    }

    public BluetoothPayloadBuilder(byte type, byte value) {
        this();
        this.append(type, value);
    }

    public BluetoothPayloadBuilder(byte type, String value) {
        this();
        this.append(type, value);
    }

    public synchronized BluetoothPayloadBuilder append(byte type, byte[] value) {
        this.payload = BluetoothPayloadUtil.appendPayload(type, value, BluetoothPayloadUtil.removePayload(type, this.payload));
        return this;
    }

    public BluetoothPayloadBuilder append(byte type, byte value) {
        byte[] bytes = new byte[]{value};
        return this.append(type, bytes);
    }

    public BluetoothPayloadBuilder append(byte type, String value) {
        return this.append(type, value.getBytes());
    }

    public synchronized BluetoothPayloadBuilder remove(byte type) {
        this.payload = BluetoothPayloadUtil.removePayload(type, this.payload);
        return this;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

