/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.ChunkedTransferCodingHandler;
import ej.hoka.http.DefaultHTTPSession;
import ej.hoka.http.HTTPSession;
import ej.hoka.http.IHTTPEncodingHandler;
import ej.hoka.http.IHTTPTransferCodingHandler;
import ej.hoka.http.IdentityEncodingHandler;
import ej.hoka.http.IdentityTransferCodingHandler;
import ej.hoka.http.body.BodyParserFactory;
import ej.hoka.log.Messages;
import ej.hoka.tcp.TCPServer;
import java.io.IOException;
import java.net.Socket;
import javax.net.ServerSocketFactory;

public class HTTPServer
extends TCPServer {
    private static final long DEFAULT_KEEP_ALIVE_DURATION = 60000L;
    private Socket[] streamConnections;
    private int lastAddedPtr;
    private int lastReadPtr;
    private final int maxOpenedConnections;
    private final int sessionJobsCount;
    protected final long keepAliveDuration;
    private Thread[] jobs;
    private IHTTPEncodingHandler[] encodingHandlers;
    private IHTTPTransferCodingHandler[] transferCodingHandlers;
    private final HTTPSession.Factory httpSessionFactory;
    private BodyParserFactory bodyParserFactory;

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCountBySession) throws IOException {
        this(port, maxSimultaneousConnection, jobCountBySession, new DefaultHTTPSession.Factory());
    }

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCountBySession, HTTPSession.Factory httpSessionFactory) throws IOException {
        this(port, maxSimultaneousConnection, jobCountBySession, httpSessionFactory, ServerSocketFactory.getDefault());
    }

    public HTTPServer(int port, int maxSimultaneousConnection, int jobCountBySession, HTTPSession.Factory httpSessionFactory, ServerSocketFactory serverSocketFactory) throws IOException {
        this(port, maxSimultaneousConnection, jobCountBySession, httpSessionFactory, serverSocketFactory, 60000L);
    }

    private HTTPServer(int port, int maxSimultaneousConnection, int jobCountBySession, HTTPSession.Factory httpSessionFactory, ServerSocketFactory serverSocketFactory, long keepAliveDuration) throws IOException {
        super(serverSocketFactory.createServerSocket(port));
        if (maxSimultaneousConnection <= 0 || jobCountBySession <= 0 || keepAliveDuration <= 0L) {
            throw new IllegalArgumentException();
        }
        this.httpSessionFactory = httpSessionFactory;
        this.maxOpenedConnections = maxSimultaneousConnection;
        this.sessionJobsCount = jobCountBySession;
        this.keepAliveDuration = keepAliveDuration;
        this.encodingHandlers = new IHTTPEncodingHandler[]{IdentityEncodingHandler.getInstance()};
        this.transferCodingHandlers = new IHTTPTransferCodingHandler[]{IdentityTransferCodingHandler.getInstance(), ChunkedTransferCodingHandler.getInstance()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addConnection(Socket connection) {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            int nextPtr = this.lastAddedPtr + 1;
            if (nextPtr == this.streamConnections.length) {
                nextPtr = 0;
            }
            if (nextPtr == this.lastReadPtr) {
                this.tooManyOpenConnections(connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.lastAddedPtr = nextPtr;
            this.streamConnections[this.lastAddedPtr] = connection;
            this.streamConnections.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Messages.LOGGER.log('I', "Hoka", 1);
            return;
        }
    }

    protected IHTTPTransferCodingHandler getChunkedTransferCodingHandler() {
        return ChunkedTransferCodingHandler.getInstance();
    }

    protected IHTTPEncodingHandler getEncodingHandler(String encoding) {
        if (encoding == null) {
            return IdentityEncodingHandler.getInstance();
        }
        IHTTPEncodingHandler[] encodingHandlers = this.encodingHandlers;
        int i = encodingHandlers.length;
        while (--i >= 0) {
            IHTTPEncodingHandler handler = encodingHandlers[i];
            if (!encoding.equalsIgnoreCase(handler.getId())) continue;
            return handler;
        }
        return null;
    }

    protected IHTTPTransferCodingHandler getIdentityTransferCodingHandler() {
        return IdentityTransferCodingHandler.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Socket getNextStreamConnection() {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            while (true) {
                if (this.lastAddedPtr != this.lastReadPtr) {
                    int nextPtr = this.lastReadPtr + 1;
                    if (nextPtr == this.streamConnections.length) {
                        nextPtr = 0;
                    }
                    this.lastReadPtr = nextPtr;
                    Socket connection = this.streamConnections[this.lastReadPtr];
                    this.streamConnections[nextPtr] = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return connection;
                }
                if (this.isStopped()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                try {
                    this.streamConnections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected IHTTPTransferCodingHandler getTransferCodingHandler(String encoding) {
        if (encoding == null) {
            return IdentityTransferCodingHandler.getInstance();
        }
        IHTTPTransferCodingHandler[] transferCodingHandlers = this.transferCodingHandlers;
        int i = transferCodingHandlers.length;
        while (--i >= 0) {
            IHTTPTransferCodingHandler handler = transferCodingHandlers[i];
            if (!encoding.equalsIgnoreCase(handler.getId())) continue;
            return handler;
        }
        return null;
    }

    public void registerEncodingHandler(IHTTPEncodingHandler handler) {
        if (!this.isStopped()) {
            throw new IllegalStateException();
        }
        if (this.encodingHandlers == null) {
            this.encodingHandlers = new IHTTPEncodingHandler[]{handler};
        } else {
            int length = this.encodingHandlers.length;
            this.encodingHandlers = new IHTTPEncodingHandler[length + 1];
            System.arraycopy(this.encodingHandlers, 0, this.encodingHandlers, 0, length);
            this.encodingHandlers[length] = handler;
        }
    }

    public void registerTransferCodingHandler(IHTTPTransferCodingHandler handler) {
        if (!this.isStopped()) {
            throw new RuntimeException();
        }
        if (this.transferCodingHandlers == null) {
            this.transferCodingHandlers = new IHTTPTransferCodingHandler[]{handler};
        } else {
            int length = this.transferCodingHandlers.length;
            this.transferCodingHandlers = new IHTTPTransferCodingHandler[length + 1];
            System.arraycopy(this.transferCodingHandlers, 0, this.transferCodingHandlers, 0, length);
            this.transferCodingHandlers[length] = handler;
        }
    }

    @Override
    public void start() {
        this.streamConnections = new Socket[this.maxOpenedConnections + 1];
        super.start();
        this.jobs = new Thread[this.sessionJobsCount];
        int i = this.sessionJobsCount;
        while (--i >= 0) {
            Thread job;
            HTTPSession session = this.httpSessionFactory.newHTTPSession(this);
            session.setBodyParserFactory(this.bodyParserFactory);
            this.jobs[i] = job = new Thread(session.getRunnable(), "HTTP-JOB-" + i);
            job.start();
        }
        Messages.LOGGER.log('I', "Hoka", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            this.streamConnections.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int i = this.jobs.length;
            while (--i >= 0) {
                try {
                    this.jobs[i].join();
                }
                catch (InterruptedException interruptedException) {}
            }
            Messages.LOGGER.log('I', "Hoka", 3);
            return;
        }
    }

    protected void tooManyOpenConnections(Socket connection) {
        Messages.LOGGER.log('S', "Hoka", -1, new Object[]{connection.getInetAddress().toString(), this.maxOpenedConnections});
        try {
            connection.close();
        }
        catch (IOException e) {
            Messages.LOGGER.log('S', "Hoka", -255, (Throwable)e);
        }
    }

    public BodyParserFactory getBodyParserFactory() {
        return this.bodyParserFactory;
    }

    public void setBodyParserFactory(BodyParserFactory bodyParserFactory) {
        this.bodyParserFactory = bodyParserFactory;
    }
}

