/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class HTTPResponse {
    public static final HTTPResponse RESPONSE_OK = HTTPResponse.createResponseFromStatus("200 OK");
    public static final HTTPResponse RESPONSE_MOVED_PERMANENTLY = HTTPResponse.createResponseFromStatus("301 Moved Permanently");
    public static final HTTPResponse RESPONSE_NOT_MODIFIED = HTTPResponse.createResponseFromStatus("304 Not Modified");
    public static final HTTPResponse RESPONSE_BAD_REQUEST = HTTPResponse.createResponseFromStatus("400 Bad Request");
    public static final HTTPResponse RESPONSE_FORBIDDEN = HTTPResponse.createResponseFromStatus("403 Forbidden");
    public static final HTTPResponse RESPONSE_NOT_FOUND = HTTPResponse.createResponseFromStatus("404 Not Found");
    public static final HTTPResponse RESPONSE_METHOD_NOT_ALLOWED = HTTPResponse.createResponseFromStatus("405 Method Not Allowed");
    public static final HTTPResponse RESPONSE_NOT_ACCEPTABLE = HTTPResponse.createResponseFromStatus("406 Not Acceptable");
    public static final HTTPResponse RESPONSE_UNSUPPORTED_MEDIA_TYPE = HTTPResponse.createResponseFromStatus("415 Unsupported Media Type");
    public static final HTTPResponse RESPONSE_INTERNAL_ERROR = HTTPResponse.createResponseFromStatus("500 Internal Server Error");
    public static final HTTPResponse RESPONSE_NOT_IMPLEMENTED = HTTPResponse.createResponseFromStatus("501 Not Implemented");
    private String status;
    private String mimeType;
    private Object data;
    private long length = -1L;
    private final HashMap<String, String> header = new HashMap(5);
    private boolean dataStreamClosed = false;

    public HTTPResponse() {
        this(new byte[0]);
    }

    public HTTPResponse(byte[] data) {
        this.setData(data);
    }

    public HTTPResponse(InputStream data) {
        this.setData(data);
    }

    public HTTPResponse(String data) {
        this(data == null ? new byte[]{} : data.getBytes());
    }

    public HTTPResponse(String data, String encoding) throws UnsupportedEncodingException {
        this(data == null ? new byte[]{} : data.getBytes(encoding));
    }

    private static HTTPResponse createResponseFromStatus(String status) {
        HTTPResponse response = new HTTPResponse();
        response.setStatus(status);
        response.addHeaderField("connection", "close");
        return response;
    }

    public void addHeaderField(String name, String value) {
        this.header.put(name, value);
    }

    protected void close() {
        InputStream data = this.getData();
        if (data != null && !this.dataStreamClosed) {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected InputStream getData() {
        try {
            return (InputStream)this.data;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Map<String, String> getHeader() {
        return (Map)this.header.clone();
    }

    protected long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    protected byte[] getRawData() {
        if (this.data instanceof byte[]) {
            return (byte[])this.data;
        }
        return null;
    }

    public String getStatus() {
        return this.status;
    }

    private void setData(byte[] data) {
        byte[] result = data == null ? new byte[]{} : data;
        this.data = result;
        this.setLength(result.length);
    }

    private void setData(InputStream dataStream) {
        this.setData(dataStream, -1L);
    }

    private void setData(InputStream dataStream, long length) {
        this.data = dataStream;
        this.setLength(length);
    }

    protected void setDataStreamClosed() {
        this.dataStreamClosed = true;
    }

    private void setLength(long length) {
        if (length < 0L) {
            this.header.remove("content-length");
        } else {
            this.header.put("content-length", Long.toString(length));
        }
        this.length = length;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

