/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.services.sps;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.RemoteServiceListener;
import ej.bluetooth.listeners.impl.DefaultRemoteServiceListener;
import ej.bluetooth.util.AttributeNotFoundException;
import ej.bluetooth.util.DescriptorHelper;
import ej.bluetooth.util.ServiceHelper;
import ej.bluetooth.util.services.sps.SerialPortConstants;

public abstract class SerialPortClient
extends DefaultRemoteServiceListener {
    private final BluetoothConnection connection;
    private final BluetoothService service;
    private final BluetoothCharacteristic tx;
    private final BluetoothCharacteristic rx;
    private final BluetoothDescriptor txCcc;

    public SerialPortClient(BluetoothConnection connection, BluetoothService service) throws AttributeNotFoundException {
        this.connection = connection;
        this.service = service;
        this.tx = ServiceHelper.getCharacteristic(service, SerialPortConstants.TX_UUID);
        this.rx = ServiceHelper.getCharacteristic(service, SerialPortConstants.RX_UUID);
        this.txCcc = ServiceHelper.getDescriptor(this.tx, DescriptorHelper.CCC_UUID);
    }

    public void start() {
        this.service.setRemoteListener((RemoteServiceListener)this);
        byte[] cccValue = DescriptorHelper.createCccValue(true, false);
        this.connection.sendWriteRequest((BluetoothAttribute)this.txCcc, cccValue);
    }

    public void stop() {
        this.service.setRemoteListener((RemoteServiceListener)new DefaultRemoteServiceListener());
    }

    public void sendData(byte[] data) {
        this.connection.sendWriteRequest((BluetoothAttribute)this.rx, data);
    }

    public void onWriteCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status) {
        if (attribute == this.rx) {
            this.onDataSent(status == 0);
        }
    }

    public void onNotificationReceived(BluetoothConnection connection, BluetoothCharacteristic characteristic, byte[] value) {
        if (characteristic == this.tx) {
            this.onDataReceived(value);
        }
    }

    protected abstract void onDataReceived(byte[] var1);

    protected abstract void onDataSent(boolean var1);
}

