/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.render;

import ej.annotation.Nullable;
import ej.bon.Constants;
import ej.microui.display.GraphicsContext;
import ej.mwt.Desktop;
import ej.mwt.Widget;

public abstract class RenderPolicy {
    protected static final String DEBUG_RENDER_ENABLED_CONSTANT = "ej.mwt.debug.render.enabled";
    protected static final String DEBUG_RENDER_MONITOR_CONSTANT = "ej.mwt.debug.render.monitor";
    @Nullable
    protected static final RenderListener MONITOR;
    private final Desktop desktop;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !RenderPolicy.class.desiredAssertionStatus();
        if (Constants.getBoolean((String)DEBUG_RENDER_ENABLED_CONSTANT)) {
            Object o;
            Class clazz = Constants.getClass((String)DEBUG_RENDER_MONITOR_CONSTANT);
            if (!RenderListener.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class set to ej.mwt.debug.render.monitor ( " + clazz.getName() + " ) does not implement " + RenderListener.class.getSimpleName());
            }
            try {
                o = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Class set to ej.mwt.debug.render.monitor cannot be instantiated", e);
            }
            if (!$assertionsDisabled && !(o instanceof RenderListener)) {
                throw new AssertionError();
            }
            MONITOR = (RenderListener)o;
        } else {
            MONITOR = null;
        }
    }

    protected RenderPolicy(Desktop desktop) {
        this.desktop = desktop;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public abstract void renderDesktop();

    public abstract void requestRender(Widget var1, int var2, int var3, int var4, int var5);

    protected void renderWidget(GraphicsContext g, Widget widget) {
        if (Constants.getBoolean((String)DEBUG_RENDER_ENABLED_CONSTANT)) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int widgetX = widget.getX();
            int widgetY = widget.getY();
            if (widgetX >= clipX + clipWidth || widgetX + widget.getWidth() <= clipX || widgetY >= clipY + clipHeight || widgetY + widget.getHeight() <= clipY) {
                return;
            }
            if (!$assertionsDisabled && MONITOR == null) {
                throw new AssertionError();
            }
            MONITOR.onRenderExecuted(widget, clipX - widget.getAbsoluteX(), clipY - widget.getAbsoluteY(), clipWidth, clipHeight);
        }
        this.desktop.renderWidget(g, widget);
    }

    public static interface RenderListener {
        public void onRenderRequested(Widget var1, int var2, int var3, int var4, int var5);

        public void onRenderExecuted(Widget var1, int var2, int var3, int var4, int var5);
    }
}

