/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import ej.annotation.Nullable;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_LONG = 8;
    private static final long WORD_MASK = -1L;
    private long[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkInvariants() {
    }

    private void recalculateWordsInUse() {
        int i = this.wordsInUse - 1;
        while (i >= 0) {
            if (this.words[i] != 0L) break;
            --i;
        }
        this.wordsInUse = i + 1;
    }

    public BitSet() {
        this.words = new long[BitSet.wordIndex(63) + 1];
        this.sizeIsSticky = false;
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.words = new long[BitSet.wordIndex(nbits - 1) + 1];
        this.sizeIsSticky = true;
    }

    private BitSet(long[] words) {
        this.words = words;
        this.wordsInUse = words.length;
        this.checkInvariants();
    }

    public static BitSet valueOf(long[] longs) {
        int n = longs.length;
        while (n > 0 && longs[n - 1] == 0L) {
            --n;
        }
        return new BitSet(BitSet.copyOf(longs, n));
    }

    public static BitSet valueOf(byte[] bytes) {
        int byteCount = bytes.length;
        BitSet bitSet = new BitSet(byteCount * 8);
        bitSet.wordsInUse = bitSet.words.length;
        int completeWordCount = byteCount / 8;
        int byteIndex = 0;
        int i = 0;
        while (i < completeWordCount) {
            bitSet.words[i] = BitSet.getLong(bytes, byteIndex);
            byteIndex += 8;
            ++i;
        }
        if (byteIndex != byteCount) {
            long lastWord = 0L;
            int offset = 0;
            int i2 = byteIndex;
            while (i2 < byteCount) {
                lastWord |= ((long)bytes[i2] & 0xFFL) << offset;
                offset += 8;
                ++i2;
            }
            bitSet.words[bitSet.words.length - 1] = lastWord;
        }
        bitSet.recalculateWordsInUse();
        return bitSet;
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse;
        if (n == 0) {
            return new byte[0];
        }
        int len = 8 * (n - 1);
        long x = this.words[n - 1];
        while (x != 0L) {
            ++len;
            x >>>= 8;
        }
        byte[] bytes = new byte[len];
        int byteIndex = 0;
        int i = 0;
        while (i < n - 1) {
            BitSet.putBytes(this.words[i], bytes, byteIndex);
            byteIndex += 8;
            ++i;
        }
        long x2 = this.words[n - 1];
        while (x2 != 0L) {
            bytes[byteIndex++] = (byte)(x2 & 0xFFL);
            x2 >>>= 8;
        }
        return bytes;
    }

    public long[] toLongArray() {
        return BitSet.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            this.words = BitSet.copyOf(this.words, request);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] ^ 1L << bitIndex;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void flip(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSet.wordIndex(fromIndex);
        int endWordIndex = BitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                int n2 = i++;
                this.words[n2] = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] ^ lastWordMask;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
        this.checkInvariants();
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSet.wordIndex(fromIndex);
        int endWordIndex = BitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                this.words[i] = -1L;
                ++i;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
        this.checkInvariants();
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = BitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                this.words[i] = 0L;
                ++i;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0L;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = BitSet.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public BitSet get(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        this.checkInvariants();
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new BitSet(0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        BitSet result = new BitSet(toIndex - fromIndex);
        int targetWords = BitSet.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = BitSet.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words[i] = wordAligned ? this.words[sourceIndex] : this.words[sourceIndex] >>> fromIndex | this.words[sourceIndex + 1] << -fromIndex;
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex;
        result.words[targetWords - 1] = (toIndex - 1 & 0x3F) < (fromIndex & 0x3F) ? this.words[sourceIndex] >>> fromIndex | (this.words[sourceIndex + 1] & lastWordMask) << -fromIndex : (this.words[sourceIndex] & lastWordMask) >>> fromIndex;
        result.wordsInUse = targetWords;
        result.recalculateWordsInUse();
        result.checkInvariants();
        return result;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + BitSet.Long_numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + BitSet.Long_numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return this.length() - 1;
        }
        long word = this.words[u] & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u];
        }
        return (u + 1) * 64 - 1 - BitSet.Long_numberOfLeadingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - BitSet.Long_numberOfLeadingZeros(word);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - BitSet.Long_numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BitSet set) {
        int i = Math.min(this.wordsInUse, set.wordsInUse) - 1;
        while (i >= 0) {
            if ((this.words[i] & set.words[i]) != 0L) {
                return true;
            }
            --i;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        int i = 0;
        while (i < this.wordsInUse) {
            sum += BitSet.Long_bitCount(this.words[i]);
            ++i;
        }
        return sum;
    }

    /*
     * Unable to fully structure code
     */
    public void and(BitSet set) {
        if (this != set) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.words[--this.wordsInUse] = 0L;
lbl4:
            // 2 sources

            ** while (this.wordsInUse > set.wordsInUse)
        }
lbl5:
        // 1 sources

        i = 0;
        while (i < this.wordsInUse) {
            v0 = i;
            this.words[v0] = this.words[v0] & set.words[i];
            ++i;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void or(BitSet set) {
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        int i = 0;
        while (i < wordsInCommon) {
            int n = i;
            this.words[n] = this.words[n] | set.words[i];
            ++i;
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
        this.checkInvariants();
    }

    public void xor(BitSet set) {
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        int i = 0;
        while (i < wordsInCommon) {
            int n = i;
            this.words[n] = this.words[n] ^ set.words[i];
            ++i;
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse - wordsInCommon);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void andNot(BitSet set) {
        int i = Math.min(this.wordsInUse, set.wordsInUse) - 1;
        while (i >= 0) {
            int n = i;
            this.words[n] = this.words[n] & (set.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
            --i;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse;
        while (--i >= 0) {
            h ^= this.words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BitSet set = (BitSet)obj;
        this.checkInvariants();
        set.checkInvariants();
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        int i = 0;
        while (i < this.wordsInUse) {
            if (this.words[i] != set.words[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        try {
            BitSet result = (BitSet)super.clone();
            result.words = (long[])this.words.clone();
            result.checkInvariants();
            return result;
        }
        catch (CloneNotSupportedException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = BitSet.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }

    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }

    private static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int Long_bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    private static int Long_numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(i >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)i;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    private static int Long_numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    private static void putBytes(long l, byte[] bytes, int index) {
        bytes[index + 7] = (byte)(l >> 56);
        bytes[index + 6] = (byte)(l >> 48);
        bytes[index + 5] = (byte)(l >> 40);
        bytes[index + 4] = (byte)(l >> 32);
        bytes[index + 3] = (byte)(l >> 24);
        bytes[index + 2] = (byte)(l >> 16);
        bytes[index + 1] = (byte)(l >> 8);
        bytes[index] = (byte)l;
    }

    private static long getLong(byte[] bytes, int index) {
        return (long)bytes[index + 7] << 56 | ((long)bytes[index + 6] & 0xFFL) << 48 | ((long)bytes[index + 5] & 0xFFL) << 40 | ((long)bytes[index + 4] & 0xFFL) << 32 | ((long)bytes[index + 3] & 0xFFL) << 24 | ((long)bytes[index + 2] & 0xFFL) << 16 | ((long)bytes[index + 1] & 0xFFL) << 8 | (long)bytes[index] & 0xFFL;
    }
}

