/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import ej.mwt.style.background.Background;
import ej.mwt.util.Alignment;

public class TiledImageBackground
implements Background {
    private final Image image;
    private final byte horizontalAlignment;
    private final byte verticalAlignment;
    private final boolean horizontalRepeat;
    private final boolean verticalRepeat;

    public TiledImageBackground(Image image) {
        this(image, 0, 3, true, true);
    }

    public TiledImageBackground(Image image, int horizontalAlignment, int verticalAlignment, boolean horizontalRepeat, boolean verticalRepeat) {
        Alignment.validateHorizontalAlignment(horizontalAlignment);
        Alignment.validateVerticalAlignment(verticalAlignment);
        this.image = image;
        this.horizontalAlignment = (byte)horizontalAlignment;
        this.verticalAlignment = (byte)verticalAlignment;
        this.horizontalRepeat = horizontalRepeat;
        this.verticalRepeat = verticalRepeat;
    }

    @Override
    public boolean isTransparent(int width, int height) {
        Image image = this.image;
        return image.isTransparent() || this.checkTransparent(this.horizontalRepeat, image.getWidth(), width) || this.checkTransparent(this.verticalRepeat, image.getHeight(), height);
    }

    private boolean checkTransparent(boolean repeat, int imageSize, int size) {
        return !repeat && imageSize < size;
    }

    @Override
    public void apply(GraphicsContext g, int width, int height) {
        int yStart;
        int xStart;
        Image image = this.image;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        boolean horizontalRepeat = this.horizontalRepeat;
        boolean verticalRepeat = this.verticalRepeat;
        byte horizontalAlignment = this.horizontalAlignment;
        byte verticalAlignment = this.verticalAlignment;
        int hrepeat = TiledImageBackground.getRepeatCount(horizontalRepeat, width, imageWidth);
        int vrepeat = TiledImageBackground.getRepeatCount(verticalRepeat, height, imageHeight);
        if (horizontalAlignment == 1) {
            if (horizontalRepeat) {
                ++hrepeat;
            }
            xStart = (width - imageWidth >> 1) - imageWidth * (hrepeat >> 1);
        } else {
            xStart = horizontalAlignment == 2 ? width - imageWidth * hrepeat : 0;
        }
        if (verticalAlignment == 4) {
            if (verticalRepeat) {
                ++vrepeat;
            }
            yStart = (height - imageHeight >> 1) - imageHeight * (vrepeat >> 1);
        } else {
            yStart = verticalAlignment == 5 ? height - imageHeight * vrepeat : 0;
        }
        int currentX = xStart;
        int i = 0;
        while (i < hrepeat) {
            int currentY = yStart;
            int j = 0;
            while (j < vrepeat) {
                Painter.drawImage((GraphicsContext)g, (Image)image, (int)currentX, (int)currentY);
                currentY += imageHeight;
                ++j;
            }
            currentX += imageWidth;
            ++i;
        }
        g.removeBackgroundColor();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            TiledImageBackground background = (TiledImageBackground)obj;
            return this.image == background.image && this.horizontalAlignment == background.horizontalAlignment && this.verticalAlignment == background.verticalAlignment && this.horizontalRepeat == background.horizontalRepeat && this.verticalRepeat == background.verticalRepeat;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.horizontalAlignment * this.verticalAlignment * (this.horizontalRepeat ? -3 : 3) * (this.verticalRepeat ? -5 : 5);
    }

    private static int getRepeatCount(boolean repeat, int size, int imageSize) {
        if (repeat) {
            return 1 + (size - 1) / imageSize;
        }
        return 1;
    }
}

