/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import ej.rcommand.RemoteConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DynamicRemoteConnection
implements RemoteConnection {
    private volatile RemoteConnection connection;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(RemoteConnection newConnection) {
        DynamicRemoteConnection dynamicRemoteConnection = this;
        synchronized (dynamicRemoteConnection) {
            RemoteConnection previousConnection = this.connection;
            this.connection = newConnection;
            if (previousConnection != null) {
                previousConnection.close();
            }
            this.notifyAll();
        }
    }

    @Override
    public String readCommand() throws IOException {
        return this.waitForConnection().readCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteConnection waitForConnection() throws IOException {
        DynamicRemoteConnection dynamicRemoteConnection = this;
        synchronized (dynamicRemoteConnection) {
            while (this.connection == null) {
                if (this.closed) {
                    throw new IOException("Connection closed");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.connection;
        }
    }

    @Override
    public String readString() throws IOException {
        return this.waitForConnection().readString();
    }

    @Override
    public long readLong() throws IOException {
        return this.waitForConnection().readLong();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        return this.waitForConnection().readByteArray();
    }

    @Override
    public InputStream readByteArrayAsInputStream() throws IOException {
        return this.waitForConnection().readByteArrayAsInputStream();
    }

    @Override
    public void startCommand(String command) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.startCommand(command);
        }
    }

    @Override
    public void sendString(String s) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendString(s);
        }
    }

    @Override
    public void sendLong(long l) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendLong(l);
        }
    }

    @Override
    public void sendByteArray(byte[] a) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendByteArray(a);
        }
    }

    @Override
    public void sendByteArrayAsInputStream(InputStream is) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendByteArrayAsInputStream(is);
        }
    }

    @Override
    public void flushCommand() {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.flushCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DynamicRemoteConnection dynamicRemoteConnection = this;
        synchronized (dynamicRemoteConnection) {
            this.closed = true;
            RemoteConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
            this.notifyAll();
        }
    }

    @Override
    public void skipParameters() throws IOException {
        this.waitForConnection().skipParameters();
    }

    @Override
    public List<Object> readParameters() throws IOException {
        return this.waitForConnection().readParameters();
    }

    @Override
    public void sendParams(List<Object> params) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendParams(params);
        }
    }

    @Override
    public void sendInt(int i) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendInt(i);
        }
    }

    @Override
    public void sendFloat(float f) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendFloat(f);
        }
    }

    @Override
    public void sendDouble(double d) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendDouble(d);
        }
    }

    @Override
    public void sendBoolean(boolean b) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendBoolean(b);
        }
    }

    @Override
    public int readInt() throws IOException {
        return this.waitForConnection().readInt();
    }

    @Override
    public float readFloat() throws IOException {
        return this.waitForConnection().readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.waitForConnection().readDouble();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.waitForConnection().readBoolean();
    }

    @Override
    public void sendInputStream(InputStream is) {
        RemoteConnection connection = this.connection;
        if (connection != null) {
            connection.sendInputStream(is);
        }
    }

    @Override
    public InputStream readInputStream() throws IOException {
        return this.waitForConnection().readInputStream();
    }
}

