/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.util;

import ej.fp.FrontPanel;
import ej.fp.Widget;

public abstract class WidgetWithListener
extends Widget {
    private String listenerClassName;

    public void setListenerClass(Class<?> expectedType, String listenerClassName) {
        FrontPanel.getFrontPanel().verifyUserClass(((Object)((Object)this)).getClass(), expectedType, listenerClassName);
        this.listenerClassName = listenerClassName;
    }

    protected synchronized <T> T newListener(Class<T> expectedType) {
        T listener = this.listenerClassName == null ? this.createDefaultListener(expectedType) : this.createUserListener(expectedType);
        return listener;
    }

    protected Object newDefaultListener() {
        return null;
    }

    private <T> T createUserListener(Class<T> expectedType) {
        return (T)FrontPanel.getFrontPanel().newUserInstance(((Object)((Object)this)).getClass(), expectedType, this.listenerClassName);
    }

    private <T> T createDefaultListener(Class<T> expectedType) {
        T listener = null;
        try {
            Object o = this.newDefaultListener();
            if (o == null) {
                throw new IllegalStateException("A listener which implements/extends " + expectedType.getName() + " is required.");
            }
            listener = expectedType.cast(o);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(String.valueOf(this.listenerClassName) + " cannot be cast to " + expectedType.getName());
        }
        return listener;
    }
}

