/*
 * Decompiled with CFR 0.152.
 */
package ej.storage.util;

import ej.storage.util.StorageMessage;

public class StorageHelper {
    private StorageHelper() {
    }

    public static void checkID(String id) {
        if (id.length() == 0) {
            throw new IllegalArgumentException(StorageMessage.BUILDER.buildMessage('S', "Storage", 101));
        }
        if (!StorageHelper.isLetter(id.charAt(0))) {
            throw new IllegalArgumentException(StorageMessage.BUILDER.buildMessage('S', "Storage", 102));
        }
        int i = 1;
        while (i < id.length()) {
            if (!StorageHelper.isValidPart(id.charAt(i))) {
                throw new IllegalArgumentException(StorageMessage.BUILDER.buildMessage('S', "Storage", 103, new Object[]{Character.toString(id.charAt(i))}));
            }
            ++i;
        }
    }

    public static boolean isValidID(String id) {
        if (id.length() == 0 || !StorageHelper.isLetter(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!StorageHelper.isValidPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException(StorageMessage.BUILDER.buildMessage('S', "Storage", 104));
        }
    }

    private static boolean isLetter(char c) {
        return Character.isLowerCase(c) || Character.isUpperCase(c) || '_' == c;
    }

    private static boolean isValidPart(char c) {
        return StorageHelper.isLetter(c) || Character.isDigit(c) || '-' == c || '.' == c;
    }
}

