/*
 * Decompiled with CFR 0.152.
 */
package ej.storage.heap;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.storage.Storage;
import ej.storage.util.StorageHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;

public class StorageHeap
implements Storage {
    private final PackedMap<String, byte[]> data = new PackedMap();

    @Override
    public OutputStream store(String id) throws IOException {
        StorageHelper.checkID(id);
        return this.createOutputStream(id, true);
    }

    private OutputStream createOutputStream(final String id, boolean overwriteData) {
        return new ByteArrayOutputStream(overwriteData){
            private boolean overwriteFirstFlush;
            private boolean closed;
            {
                this.overwriteFirstFlush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                if (!this.closed) {
                    byte[] data;
                    boolean overwriteFirstFlush;
                    1 var2_1 = this;
                    synchronized (var2_1) {
                        overwriteFirstFlush = this.overwriteFirstFlush;
                        this.overwriteFirstFlush = false;
                    }
                    if (overwriteFirstFlush) {
                        StorageHeap.this.data.remove((Object)id);
                    }
                    byte[] oldData = (byte[])StorageHeap.this.data.get((Object)id);
                    byte[] newData = this.toByteArray();
                    if (oldData != null) {
                        int oldDataLength = oldData.length;
                        int newDataLength = newData.length;
                        data = new byte[oldDataLength + newDataLength];
                        System.arraycopy(oldData, 0, data, 0, oldDataLength);
                        System.arraycopy(newData, 0, data, oldDataLength, newDataLength);
                    } else {
                        data = newData;
                    }
                    StorageHeap.this.data.put((Object)id, (Object)data);
                }
                this.reset();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                this.closed = true;
            }
        };
    }

    @Override
    public OutputStream modify(String id, int offset) throws IOException {
        StorageHelper.checkID(id);
        StorageHelper.checkOffset(offset);
        return this.createOutputStreamModify(id, offset);
    }

    private OutputStream createOutputStreamModify(final String id, int offset) {
        return new ByteArrayOutputStream(offset){
            private int position;
            private boolean closed;
            {
                this.position = n;
            }

            @Override
            public void flush() throws IOException {
                if (!this.closed) {
                    byte[] oldData = (byte[])StorageHeap.this.data.get((Object)id);
                    byte[] newData = this.toByteArray();
                    int position = this.position;
                    int oldDataLength = oldData == null ? 0 : oldData.length;
                    int newDataLength = newData.length;
                    int dataLength = Math.max(oldDataLength, position + newDataLength);
                    byte[] data = new byte[dataLength];
                    if (oldData != null) {
                        System.arraycopy(oldData, 0, data, 0, oldDataLength);
                    }
                    System.arraycopy(newData, 0, data, position, newDataLength);
                    StorageHeap.this.data.put((Object)id, (Object)data);
                    this.position += newDataLength;
                }
                this.reset();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                this.closed = true;
            }
        };
    }

    @Override
    public OutputStream append(String id) throws IOException {
        StorageHelper.checkID(id);
        return this.createOutputStream(id, false);
    }

    @Override
    @Nullable
    public InputStream load(String id) throws IOException {
        StorageHelper.checkID(id);
        byte[] bytes = (byte[])this.data.get((Object)id);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void move(String sourceId, String destinationId) throws IOException {
        StorageHelper.checkID(sourceId);
        StorageHelper.checkID(destinationId);
        byte[] data = (byte[])this.data.remove((Object)sourceId);
        if (data == null) {
            throw new IOException();
        }
        this.data.put((Object)destinationId, (Object)data);
    }

    @Override
    public void remove(String id) throws IOException {
        StorageHelper.checkID(id);
        byte[] data = (byte[])this.data.remove((Object)id);
        if (data == null) {
            throw new IOException();
        }
    }

    @Override
    public long getSize(String id) throws IOException {
        StorageHelper.checkID(id);
        byte[] data = (byte[])this.data.get((Object)id);
        if (data != null) {
            return data.length;
        }
        throw new IOException();
    }

    @Override
    public boolean exists(String id) throws IOException {
        StorageHelper.checkID(id);
        return this.data.get((Object)id) != null;
    }

    @Override
    public String[] getIds() throws IOException {
        Set keySet = this.data.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }
}

