/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.Composite;
import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.MouseListener;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.brs.BufferRefreshStrategy;
import ej.fp.widget.display.brs.PredrawRefreshStrategy;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.fp.widget.display.buffer.SwapDoubleBufferPolicy;
import ej.microui.display.LLUIDisplayImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label", isOptional=true), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="width"), @Widget.WidgetAttribute(name="height"), @Widget.WidgetAttribute(name="displayWidth", isOptional=true), @Widget.WidgetAttribute(name="displayHeight", isOptional=true), @Widget.WidgetAttribute(name="initialColor", isOptional=true), @Widget.WidgetAttribute(name="alpha", isOptional=true), @Widget.WidgetAttribute(name="flushTime", isOptional=true), @Widget.WidgetAttribute(name="refreshRate", isOptional=true), @Widget.WidgetAttribute(name="backlightFeature", isOptional=true), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="extensionClass", isOptional=true), @Widget.WidgetAttribute(name="bufferPolicyClass", isOptional=true), @Widget.WidgetAttribute(name="refreshStrategyClass", isOptional=true)})
public class Display
extends Composite
implements LLUIDisplayImpl,
MouseListener {
    private static final String IMAGES_PREFIX = "images/";
    private static final String DISPLAY_COORDINATES_PATTERN = "Display: {0}, {1}";
    private static final int TOOL_BAR_POSITION = 1;
    private static final int STATUS_BAR_POSITION = 2;
    private static final int STATUS_BAR_LEFT_POSITION = 0;
    private static final int STATUS_BAR_CENTER_POSITION = 1;
    private static final int SCREENSHOT_NOTIFICATION_DURATION = 5000;
    private static final String PROPERTY_FLUSH_TIME = "ej.fp.display.flushTime";
    private static final String PROPERTY_FLUSH_TIME_LEGACY = "ej.fp.widget.display.flushTime";
    private static final String PROPERTY_REFRESH_RATE = "ej.fp.display.refreshRate";
    private static final String PROPERTY_REFRESH_RATE_LEGACY = "ej.fp.widget.display.refreshRate";
    private DisplayBufferManager bufferManager;
    private Image visibleBuffer;
    private DisplayExtension extension;
    private String extensionClassName;
    private int displayWidth;
    private int displayHeight;
    private String bufferPolicyClass;
    private String refreshStrategyClass;
    private int initialColor;
    private byte alpha = (byte)-1;
    private boolean hasBacklight = true;
    private int flushTimeMs;
    private int refreshRateHz;
    private int refreshRateTimeMs;
    private int backlight;
    private AbstractAction screenshotAction;
    private JLabel coordinatesLabel;
    private JLabel screenshotNotificationLabel;
    private int screenshotNotificationCounter;
    private File outputDir;

    public void setDisplayWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Display width cannot be negative.");
        }
        this.displayWidth = width;
    }

    public void setDisplayHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Display height cannot be negative.");
        }
        this.displayHeight = height;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setInitialColor(int initialColor) {
        this.initialColor = initialColor | 0xFF000000;
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("The opacity level must be a value between 0x0 and 0xff");
        }
        this.alpha = (byte)alpha;
    }

    public void setFlushTime(int ms) {
        this.flushTimeMs = ms > 0 ? ms : 0;
    }

    public void setRefreshRate(int hertz) {
        if (hertz > 0) {
            this.refreshRateHz = hertz > 0 ? hertz : 0;
            this.refreshRateTimeMs = 1000 / hertz;
        } else {
            this.refreshRateHz = 0;
            this.refreshRateTimeMs = 0;
        }
    }

    public void setBacklightFeature(boolean enable) {
        this.hasBacklight = enable;
    }

    public void setExtensionClass(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public void setBufferPolicyClass(String bufferPolicyClassName) {
        this.bufferPolicyClass = bufferPolicyClassName;
    }

    public void setRefreshStrategyClass(String refreshStrategyClassName) {
        this.refreshStrategyClass = refreshStrategyClassName;
    }

    public synchronized void finalizeConfiguration() {
        super.finalizeConfiguration();
        if (this.displayWidth == 0) {
            this.displayWidth = this.getWidth();
        }
        if (this.displayHeight == 0) {
            this.displayHeight = this.getHeight();
        }
        if (this.extensionClassName != null) {
            FrontPanel.getFrontPanel().verifyUserClass(((Object)((Object)this)).getClass(), DisplayExtension.class, this.extensionClassName);
        }
        if (this.bufferPolicyClass != null) {
            FrontPanel.getFrontPanel().verifyUserClass(((Object)((Object)this)).getClass(), DisplayBufferPolicy.class, this.bufferPolicyClass);
        }
        if (this.refreshStrategyClass != null) {
            FrontPanel.getFrontPanel().verifyUserClass(((Object)((Object)this)).getClass(), BufferRefreshStrategy.class, this.refreshStrategyClass);
        }
        this.setOverlay(true);
        this.setFlushTime(this.getValue(PROPERTY_FLUSH_TIME, PROPERTY_FLUSH_TIME_LEGACY, this.flushTimeMs));
        this.setRefreshRate(this.getValue(PROPERTY_REFRESH_RATE, PROPERTY_REFRESH_RATE_LEGACY, this.refreshRateHz));
        if (this.getFilter() == null && this.alpha != -1) {
            int color = this.alpha;
            Image filter = FrontPanel.getFrontPanel().newImage(this.getWidth(), this.getHeight(), color <<= 24, true);
            filter.fillRectangle(0, 0, this.getWidth(), this.getHeight(), color);
            this.setFilter(filter);
        }
    }

    public void showYourself(boolean appearSwitchedOn) {
        DisplayBufferManager buffer = this.bufferManager;
        buffer.fillRectangle(0, 0, buffer.getWidth(), buffer.getHeight(), this.convertDisplayColorToARGBColor(this.convertARGBColorToDisplayColor(appearSwitchedOn ? ~this.getInitialColor() : this.getInitialColor())));
        buffer.flush();
    }

    public void start() {
        super.start();
        if (this.extensionClassName != null) {
            this.extension = (DisplayExtension)FrontPanel.getFrontPanel().newUserInstance(((Object)((Object)this)).getClass(), DisplayExtension.class, this.extensionClassName);
        }
        this.visibleBuffer = this.newWidgetImage();
        DisplayBufferPolicy bufferPolicy = this.bufferPolicyClass != null ? (DisplayBufferPolicy)FrontPanel.getFrontPanel().newUserInstance(((Object)((Object)this)).getClass(), DisplayBufferPolicy.class, this.bufferPolicyClass) : new SwapDoubleBufferPolicy();
        BufferRefreshStrategy refreshStrategy = this.refreshStrategyClass != null ? (BufferRefreshStrategy)FrontPanel.getFrontPanel().newUserInstance(((Object)((Object)this)).getClass(), BufferRefreshStrategy.class, this.refreshStrategyClass) : new PredrawRefreshStrategy();
        this.bufferManager = new DisplayBufferManager(bufferPolicy, refreshStrategy, (Widget)this, this.displayWidth, this.displayHeight, this.initialColor);
        this.bufferManager.setFlushTime(this.flushTimeMs);
        this.bufferManager.setRefreshTime(this.refreshRateTimeMs);
        this.setBacklight(100);
        this.populateToolBar();
        this.populateStatusBar();
    }

    private void populateToolBar() {
        Container frame = this.getFPMainContainer();
        JToolBar toolBar = (JToolBar)frame.getComponent(1);
        ImageIcon screenshotIcon = this.getIcon("screenshot.png");
        this.screenshotAction = new AbstractAction(null, screenshotIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.createScreenshot();
            }
        };
        this.screenshotAction.putValue("ShortDescription", "Screenshot");
        toolBar.add(this.screenshotAction);
        this.outputDir = Paths.get(System.getProperty("application.output.dir"), "screenshots").toFile();
        this.outputDir.mkdirs();
        toolBar.addSeparator();
    }

    private void populateStatusBar() {
        Container frame = this.getFPMainContainer();
        JPanel statusBar = (JPanel)frame.getComponent(2);
        this.coordinatesLabel = new JLabel(this.coordinatesToString(0, 0));
        this.coordinatesLabel.setEnabled(false);
        JSeparator coordinatesLabelSeparator = new JSeparator(1);
        Dimension coordinatesLabelPreferredSize = coordinatesLabelSeparator.getPreferredSize();
        coordinatesLabelPreferredSize.height = this.coordinatesLabel.getPreferredSize().height;
        coordinatesLabelSeparator.setPreferredSize(coordinatesLabelPreferredSize);
        JPanel statusBarLeft = (JPanel)statusBar.getComponent(0);
        statusBarLeft.add((Component)coordinatesLabelSeparator, 0);
        statusBarLeft.add((Component)this.coordinatesLabel, 0);
        this.screenshotNotificationLabel = new JLabel("<html>A new screenshot is <u>available<u></html>");
        this.screenshotNotificationLabel.setForeground(Color.BLUE);
        this.screenshotNotificationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().open(Display.this.outputDir);
                }
                catch (IOException iOException) {}
            }
        });
        this.screenshotNotificationLabel.setVisible(false);
        JPanel statusBarCenter = (JPanel)statusBar.getComponent(1);
        statusBarCenter.add(this.screenshotNotificationLabel);
    }

    private Container getFPMainContainer() {
        FrontPanel frontPanel = FrontPanel.getFrontPanel();
        return ((JComponent)frontPanel.getDeviceWidget()).getParent().getParent();
    }

    private ImageIcon getIcon(String name) {
        return new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource(IMAGES_PREFIX + name));
    }

    private void createScreenshot() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        Date now = new Date();
        String date = dateFormat.format(now);
        File outputFile = new File(this.outputDir, "fp_screenshot_" + date + ".png");
        try {
            ImageIO.write((RenderedImage)((BufferedImage)this.visibleBuffer.getRAWImage()), "png", outputFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create image " + outputFile, e);
        }
        ++this.screenshotNotificationCounter;
        this.screenshotNotificationLabel.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                try {
                    3.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                Display display = Display.this;
                int n = display.screenshotNotificationCounter - 1;
                display.screenshotNotificationCounter = n;
                if (n == 0) {
                    Display.this.screenshotNotificationLabel.setVisible(false);
                }
            }
        }.start();
    }

    private void updateCoordinatesLabel(int x, int y) {
        this.coordinatesLabel.setText(this.coordinatesToString(x, y));
        this.coordinatesLabel.repaint();
    }

    private String coordinatesToString(int x, int y) {
        return MessageFormat.format(DISPLAY_COORDINATES_PATTERN, x, y);
    }

    public void dispose() {
        this.bufferManager.dispose();
        this.bufferManager = null;
        this.visibleBuffer = null;
        super.dispose();
    }

    public Image getDisplayedImage() {
        return this.getCurrentSkin();
    }

    public synchronized Image getCurrentSkin() {
        Image resultImage = this.visibleBuffer;
        resultImage.drawImage(this.bufferManager.getDisplayImage());
        this.drawContrast(resultImage);
        this.drawBacklight(resultImage);
        resultImage.crop(this.getFilter());
        return resultImage;
    }

    public int getInitialColor() {
        return this.initialColor;
    }

    public Image initialize() {
        return this.bufferManager;
    }

    public boolean hasBacklight() {
        return this.hasBacklight;
    }

    public int getBacklight() {
        return this.hasBacklight() ? this.backlight : 0;
    }

    public void setBacklight(int backlight) {
        if (this.hasBacklight()) {
            this.backlight = this.backlight < 0 ? 0 : (this.backlight > 100 ? 100 : backlight);
            this.repaint();
        }
    }

    public boolean isColor() {
        return this.extension != null ? this.extension.isColor(this) : super.isColor();
    }

    public int getNumberOfColors() {
        return this.extension != null ? this.extension.getNumberOfColors(this) : super.getNumberOfColors();
    }

    public int convertARGBColorToDisplayColor(int argbColor) {
        return this.extension != null ? this.extension.convertARGBColorToDisplayColor(this, argbColor) : super.convertARGBColorToDisplayColor(argbColor);
    }

    public int convertDisplayColorToARGBColor(int displayColor) {
        return this.extension != null ? this.extension.convertDisplayColorToARGBColor(this, displayColor) : super.convertDisplayColorToARGBColor(displayColor);
    }

    public boolean prepareBlendingOfIndexedColors(AtomicInteger foreground, AtomicInteger background) {
        return this.extension != null ? this.extension.prepareBlendingOfIndexedColors(this, foreground, background) : super.prepareBlendingOfIndexedColors(foreground, background);
    }

    public Image getCurrentBackBuffer() {
        return this.bufferManager.getCurrentBackBuffer();
    }

    public Image getCurrentDrawingBuffer() {
        return this.bufferManager.getCurrentBackBuffer();
    }

    public boolean isDoubleBuffered() {
        return this.bufferManager.isDoubleBuffered();
    }

    public void flush() {
        this.bufferManager.flush();
    }

    public void waitFlush() {
        this.bufferManager.waitFlush();
    }

    public void newDrawingRegion(int x1, int y1, int x2, int y2, boolean drawingNow) {
        this.bufferManager.newDrawingRegion(x1, y1, x2, y2, drawingNow);
    }

    public void repaint() {
        if (this.alpha != -1) {
            this.getParent().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            super.repaint();
        }
    }

    protected Image newDisplayImage() {
        return FrontPanel.getFrontPanel().newImage(this.displayWidth, this.displayHeight, this.initialColor, false);
    }

    protected Image newWidgetImage() {
        return FrontPanel.getFrontPanel().newImage(this.getWidth(), this.getHeight(), this.initialColor, true);
    }

    protected void drawContrast(Image imageSkin) {
    }

    protected void drawBacklight(Image imageSkin) {
        if (this.hasBacklight()) {
            int shadow = (100 - this.getBacklight()) * 255 / 100;
            imageSkin.fillTransparentRectangle(0, 0, imageSkin.getWidth(), imageSkin.getHeight(), shadow << 24);
        }
    }

    private int getValue(String property, String legacyProperty, int defaultValue) {
        return Integer.getInteger(property, Integer.getInteger(legacyProperty, defaultValue));
    }

    public void mouseDragged(int x, int y) {
        this.mouseMoved(x, y);
    }

    public void mouseMoved(int x, int y) {
        this.coordinatesLabel.setEnabled(true);
        this.updateCoordinatesLabel(x, y);
    }

    public void mouseExited(int x, int y) {
        this.coordinatesLabel.setEnabled(false);
    }

    public static interface DisplayExtension {
        public boolean isColor(Display var1);

        public int getNumberOfColors(Display var1);

        public int convertARGBColorToDisplayColor(Display var1, int var2);

        public int convertDisplayColorToARGBColor(Display var1, int var2);

        default public boolean prepareBlendingOfIndexedColors(Display display, AtomicInteger foreground, AtomicInteger background) {
            return false;
        }
    }
}

