/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.fp.Image;
import ej.microui.display.LLUIDisplay;

public class LLUIPainter {
    public static final int DRAWING_SUCCESS = 0;
    public static final int DRAWING_LOG_ERROR = Integer.MIN_VALUE;
    public static final int DRAWING_LOG_NOT_IMPLEMENTED = 1;
    public static final int DRAWING_LOG_FORBIDDEN = 2;
    public static final int DRAWING_LOG_OUT_OF_MEMORY = 4;
    public static final int DRAWING_LOG_CLIP_MODIFIED = 8;
    public static final int DRAWING_LOG_MISSING_CHARACTER = 16;
    public static final int DRAWING_LOG_LIBRARY_INCIDENT = 0x20000000;
    public static final int DRAWING_LOG_UNKNOWN_INCIDENT = 0x40000000;

    private LLUIPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePixel(byte[] target, int x, int y) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && gc.isPointInClip(x, y)) {
                gc.configureClip(false);
                LLUIDisplay.Instance.getUIDrawer(gc).writePixel(gc, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(byte[] target, int x1, int y1, int x2, int y2) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawLine(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHorizontalLine(byte[] target, int x, int y, int width) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0) {
                int x1 = x;
                int x2 = x + width - 1;
                gc.configureClip(!gc.isHorizontalLineInClip(x1, x2, y));
                LLUIDisplay.Instance.getUIDrawer(gc).drawHorizontalLine(gc, x1, x2, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawVerticalLine(byte[] target, int x, int y, int height) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && height > 0) {
                int y1 = y;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isVerticalLineInClip(y1, y2, x));
                LLUIDisplay.Instance.getUIDrawer(gc).drawVerticalLine(gc, x, y1, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                int x1 = x;
                int y1 = y;
                int x2 = x + width - 1;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isRectangleInClip(x1, y1, x2, y2));
                LLUIDisplay.Instance.getUIDrawer(gc).drawRectangle(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                int x1 = x;
                int y1 = y;
                int x2 = x + width - 1;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isRectangleInClip(x1, y1, x2, y2));
                LLUIDisplay.Instance.getUIDrawer(gc).fillRectangle(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).drawCircleArc(gc, x, y, diameter, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).fillCircleArc(gc, x, y, diameter, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawEllipse(gc, x, y, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillEllipse(gc, x, y, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).drawCircle(gc, x, y, diameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).fillCircle(gc, x, y, diameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(byte[] target, byte[] source, int regionX, int regionY, int width, int height, int x, int y, int alpha) {
        LLUIDisplay graphicalEngine;
        LLUIDisplay lLUIDisplay = graphicalEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicalEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicalEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && !image.isClosed() && alpha > 0) {
                if (regionX < 0) {
                    width += regionX;
                    x -= regionX;
                    regionX = 0;
                }
                if (regionX + width > image.getWidth()) {
                    width = image.getWidth() - regionX;
                }
                if (regionY < 0) {
                    height += regionY;
                    y -= regionY;
                    regionY = 0;
                }
                if (regionY + height > image.getHeight()) {
                    height = image.getHeight() - regionY;
                }
                if (x < 0) {
                    width += x;
                    regionX -= x;
                    x = 0;
                }
                if (x + width > gc.getWidth()) {
                    width = gc.getWidth() - x;
                }
                if (y < 0) {
                    height += y;
                    regionY -= y;
                    y = 0;
                }
                if (y + height > gc.getHeight()) {
                    height = gc.getHeight() - y;
                }
                if (width > 0 && height > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawImage(gc, image, regionX, regionY, width, height, x, y, alpha);
                }
            }
        }
    }

    public static interface MicroUIGraphicsContext
    extends MicroUIImage {
        public int getMicroUIColor();

        public void setMicroUIColor(int var1);

        public int getRenderingColor();

        public int getClipX1();

        public int getClipY1();

        public int getClipX2();

        public int getClipY2();

        public void setClip(int var1, int var2, int var3, int var4);

        public void intersectClip(int var1, int var2, int var3, int var4);

        public void configureClip(boolean var1);

        public boolean isClipEnabled();

        public boolean isPointInClip(int var1, int var2);

        public boolean isHorizontalLineInClip(int var1, int var2, int var3);

        public boolean isVerticalLineInClip(int var1, int var2, int var3);

        public boolean isRectangleInClip(int var1, int var2, int var3, int var4);

        public boolean isRegionInClip(int var1, int var2, int var3, int var4);

        public boolean regionsOverlap(MicroUIImage var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public int getEllipsisWidth();

        public int getAndClearDrawingLogFlags();

        public void reportWarning(int var1);

        public void reportError(int var1);

        public boolean requestDrawing();

        public boolean setDrawingLimits(int var1, int var2, int var3, int var4);
    }

    public static interface MicroUIImage {
        public int getWidth();

        public int getHeight();

        public MicroUIImageFormat getFormat();

        public Image getImage();

        public Image getImage(int var1);

        public boolean isLCD();

        public boolean isClosed();

        public int readPixel(int var1, int var2);
    }

    public static enum MicroUIImageFormat {
        MICROUI_IMAGE_FORMAT_DISPLAY,
        MICROUI_IMAGE_FORMAT_ARGB8888,
        MICROUI_IMAGE_FORMAT_RGB888,
        MICROUI_IMAGE_FORMAT_RGB565,
        MICROUI_IMAGE_FORMAT_ARGB1555,
        MICROUI_IMAGE_FORMAT_ARGB4444,
        MICROUI_IMAGE_FORMAT_A1,
        MICROUI_IMAGE_FORMAT_A2,
        MICROUI_IMAGE_FORMAT_A4,
        MICROUI_IMAGE_FORMAT_A8,
        MICROUI_IMAGE_FORMAT_C1,
        MICROUI_IMAGE_FORMAT_C2,
        MICROUI_IMAGE_FORMAT_C4,
        MICROUI_IMAGE_FORMAT_AC11,
        MICROUI_IMAGE_FORMAT_AC22,
        MICROUI_IMAGE_FORMAT_AC44,
        MICROUI_IMAGE_FORMAT_LARGB8888,
        MICROUI_IMAGE_FORMAT_LRGB888,
        MICROUI_IMAGE_FORMAT_CUSTOM_7,
        MICROUI_IMAGE_FORMAT_CUSTOM_6,
        MICROUI_IMAGE_FORMAT_CUSTOM_5,
        MICROUI_IMAGE_FORMAT_CUSTOM_4,
        MICROUI_IMAGE_FORMAT_CUSTOM_3,
        MICROUI_IMAGE_FORMAT_CUSTOM_2,
        MICROUI_IMAGE_FORMAT_CUSTOM_1,
        MICROUI_IMAGE_FORMAT_CUSTOM_0,
        MICROUI_IMAGE_FORMAT_INTERNAL;

    }
}

