/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.synchronous;

import ej.rcommand.RemoteNotificationListener;
import ej.rcommand.impl.StreamRemoteConnection;
import ej.rcommand.synchronous.Command;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RemoteCommandClient
implements Runnable {
    private final Object connectionMonitor;
    private final StreamRemoteConnection connection;
    private final Map<Integer, Command<?>> pendingRequests;
    private final Map<String, RemoteNotificationListener> notificationListeners;
    private int nextId;
    private volatile boolean stopped;

    public RemoteCommandClient(StreamRemoteConnection connection) {
        this.connection = connection;
        this.connectionMonitor = new Object();
        this.pendingRequests = new HashMap();
        this.notificationListeners = new HashMap<String, RemoteNotificationListener>();
        new Thread((Runnable)this, "RemoteCommandClient").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationListener(RemoteNotificationListener listener) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.notificationListeners.put(listener.getName(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            try {
                String commandName = this.connection.readCommand();
                int commandId = this.connection.readInt();
                Object object = this.connectionMonitor;
                synchronized (object) {
                    if (commandId == -1) {
                        RemoteNotificationListener listener = this.notificationListeners.get(commandName);
                        if (listener != null) {
                            listener.notificationReceived(this.connection);
                        }
                    } else {
                        Command<?> command = this.pendingRequests.remove(commandId);
                        if (command != null) {
                            command.readResponse(this.connection);
                            this.connectionMonitor.notifyAll();
                        }
                    }
                    this.connection.skipParameters();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    this.connection.skipParameters();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                this.stopped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command, long timeout) throws IOException, InterruptedException, TimeoutException {
        boolean infiniteWaiting = timeout == 0L;
        Object object = this.connectionMonitor;
        synchronized (object) {
            int commandId = this.nextId++;
            this.pendingRequests.put(commandId, command);
            this.connection.startCommand(command.getName());
            this.connection.sendInt(commandId);
            command.writeBody(this.connection);
            this.connection.flushCommand();
            long timeReference = System.currentTimeMillis();
            while (!command.isResponseReceived() && (timeout >= 0L || infiniteWaiting)) {
                long newTimeReference;
                if (!infiniteWaiting && (timeout -= (newTimeReference = System.currentTimeMillis()) - (timeReference = newTimeReference)) <= 0L) break;
                try {
                    this.connectionMonitor.wait(timeout);
                }
                catch (InterruptedException e) {
                    this.pendingRequests.remove(commandId);
                    throw e;
                }
            }
            this.pendingRequests.remove(commandId);
            T response = command.getResponse();
            if (response == null) {
                throw new TimeoutException();
            }
            return response;
        }
    }

    public void stop() {
        this.stopped = false;
        this.connection.close();
    }
}

