/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket;

import ej.bon.Util;
import ej.util.concurrent.SingleThreadExecutor;
import ej.websocket.Messages;
import ej.websocket.ReasonForClosure;
import ej.websocket.WebSocket;

class OnTimeOutCloser
implements Runnable {
    private static final long TIMEOUT_BEFORE_FORCING_TO_CLOSE = 1000L;
    private static final Object mutex = new Object();
    private static SingleThreadExecutor EXECUTOR;
    private static int PENDING;
    private final WebSocket ws;
    private boolean closed;
    private long timeout;

    OnTimeOutCloser(WebSocket ws) {
        this.ws = ws;
        this.closed = false;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Messages.LOGGER.log('F', Messages.CATEGORY, 0, new Object[]{this});
        try {
            long sleep = this.timeout - Util.platformTimeMillis();
            if (sleep > 0L) {
                Thread.sleep(sleep);
            }
            if (this.closed) {
                Messages.LOGGER.log('G', Messages.CATEGORY, 1, new Object[]{this});
            } else {
                Messages.LOGGER.log('I', Messages.CATEGORY, 2, new Object[]{this});
                this.ws.closeUnderlyingTCPConnection();
                this.ws.getEndpoint().onClose(this.ws, new ReasonForClosure(1006, ""));
            }
        }
        catch (InterruptedException ie) {
            Messages.LOGGER.log('S', Messages.CATEGORY, 3, new Object[]{this});
            this.ws.getEndpoint().onError(this.ws, ie);
            this.ws.closeUnderlyingTCPConnection();
        }
        Object object = mutex;
        synchronized (object) {
            if (--PENDING <= 0 && EXECUTOR != null) {
                EXECUTOR.shutdown();
                EXECUTOR = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        this.timeout = Util.platformTimeMillis() + 1000L;
        Object object = mutex;
        synchronized (object) {
            if (EXECUTOR == null) {
                EXECUTOR = new SingleThreadExecutor();
                PENDING = 0;
            }
            ++PENDING;
        }
        EXECUTOR.execute((Runnable)this);
    }
}

