/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.debug;

import ej.mwt.Container;
import ej.mwt.Widget;

public class HierarchyInspector {
    private HierarchyInspector() {
    }

    public static int countNumberOfContainers(Widget widget) {
        int number = 0;
        if (widget instanceof Container) {
            ++number;
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                number += HierarchyInspector.countNumberOfContainers(child);
                ++i;
            }
        }
        return number;
    }

    public static int countNumberOfWidgets(Widget widget) {
        int number = 0;
        if (widget instanceof Container) {
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                number += HierarchyInspector.countNumberOfWidgets(child);
                ++i;
            }
        } else {
            ++number;
        }
        return number;
    }

    public static int countMaxDepth(Widget widget) {
        return HierarchyInspector.countMaxDepth(widget, 0);
    }

    private static int countMaxDepth(Widget widget, int currentDepth) {
        int maxDepth = currentDepth;
        if (widget instanceof Container) {
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                int childDepth = HierarchyInspector.countMaxDepth(child, currentDepth + 1);
                maxDepth = Math.max(maxDepth, childDepth);
                ++i;
            }
        }
        return maxDepth;
    }
}

