/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class Flow
extends Container {
    private boolean orientation;

    public Flow(boolean orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public void addChild(Widget child) {
        super.addChild(child);
    }

    public void removeChild(Widget child) {
        super.removeChild(child);
    }

    public void insertChild(Widget child, int index) {
        super.insertChild(child, index);
    }

    public void replaceChild(int index, Widget child) {
        super.replaceChild(index, child);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
    }

    protected void computeContentOptimalSize(Size size) {
        Widget[] children;
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        Widget[] widgetArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            assert (child != null);
            this.computeChildOptimalSize(child, widthHint, heightHint);
            ++n2;
        }
        boolean isHorizontal = this.orientation;
        int mainSizeHint = isHorizontal ? widthHint : heightHint;
        int[] totalSize = new int[2];
        Flow.computeTotalSize(children, isHorizontal, mainSizeHint, totalSize);
        if (isHorizontal) {
            size.setSize(totalSize[0], totalSize[1]);
        } else {
            size.setSize(totalSize[1], totalSize[0]);
        }
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        boolean isHorizontal = this.orientation;
        int mainContentLength = isHorizontal ? contentWidth : contentHeight;
        int otherContentLength = isHorizontal ? contentHeight : contentWidth;
        Widget[] children = this.getChildren();
        int[] size = new int[2];
        Flow.computeTotalSize(children, isHorizontal, mainContentLength, size);
        int otherTotalLength = size[1];
        int rowPosition = 0;
        int childrenOffset = 0;
        while (childrenOffset < children.length) {
            int newChildrenOffset = Flow.computeRowSize(children, childrenOffset, isHorizontal, mainContentLength, size);
            int mainRowLength = size[0];
            int otherRowLength = size[1];
            int rowStart = rowPosition * otherContentLength / otherTotalLength;
            int rowEnd = (rowPosition + otherRowLength) * otherContentLength / otherTotalLength;
            int widgetPosition = 0;
            int i = childrenOffset;
            while (i < newChildrenOffset) {
                Widget child = children[i];
                assert (child != null);
                int mainWidgetLength = isHorizontal ? child.getWidth() : child.getHeight();
                int widgetStart = widgetPosition * mainContentLength / mainRowLength;
                int widgetEnd = (widgetPosition + mainWidgetLength) * mainContentLength / mainRowLength;
                if (isHorizontal) {
                    this.layOutChild(child, widgetStart, rowStart, widgetEnd - widgetStart, rowEnd - rowStart);
                } else {
                    this.layOutChild(child, rowStart, widgetStart, rowEnd - rowStart, widgetEnd - widgetStart);
                }
                widgetPosition += mainWidgetLength;
                ++i;
            }
            rowPosition += otherRowLength;
            childrenOffset = newChildrenOffset;
        }
    }

    private static void computeTotalSize(Widget[] widgets, boolean isHorizontal, int maxRowSize, int[] size) {
        int mainMax = 0;
        int otherTotal = 0;
        int widgetsOffset = 0;
        while (widgetsOffset < widgets.length) {
            widgetsOffset = Flow.computeRowSize(widgets, widgetsOffset, isHorizontal, maxRowSize, size);
            mainMax = Math.max(size[0], mainMax);
            otherTotal += size[1];
        }
        size[0] = mainMax;
        size[1] = otherTotal;
    }

    private static int computeRowSize(Widget[] widgets, int widgetsOffset, boolean isHorizontal, int maxRowSize, int[] size) {
        int mainTotal = 0;
        int otherMax = 0;
        int childrenIndex = widgetsOffset;
        while (childrenIndex < widgets.length) {
            int otherChildLength;
            Widget child = widgets[childrenIndex];
            assert (child != null);
            int mainChildLength = isHorizontal ? child.getWidth() : child.getHeight();
            int n = otherChildLength = isHorizontal ? child.getHeight() : child.getWidth();
            if (maxRowSize != 0 && mainTotal + mainChildLength > maxRowSize && childrenIndex != widgetsOffset) break;
            mainTotal += mainChildLength;
            otherMax = Math.max(otherChildLength, otherMax);
            ++childrenIndex;
        }
        size[0] = mainTotal;
        size[1] = otherMax;
        return childrenIndex;
    }
}

