/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.RemoteServiceListener;

/**
 * The <code>BluetoothService</code> class represents a remote or a local GATT service.
 * <p>
 * Remote services may be retrieved by listening to
 * {@link ej.bluetooth.listeners.ConnectionListener#onDiscoveryResult(BluetoothConnection, BluetoothService) connection
 * events} while {@link BluetoothConnection#discoverServices() discovering the services} of a device. The GATT events
 * related to a remote service may be handled by {@link #setRemoteListener(RemoteServiceListener) setting the remote
 * listener} of the service.
 * <p>
 * Local services may be retrieved by {@link BluetoothAdapter#addService(BluetoothServiceDefinition) adding a local
 * service} to the adapter. The GATT events related to a local service may be handled by
 * {@link #setLocalListener(LocalServiceListener) setting the local listener} of the service.
 * <p>
 * This class provides methods to get the UUID of the service and to get its characteristics.
 */
public class BluetoothService {

	/**
	 * Private constructor.
	 */
	private BluetoothService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the UUID of this service.
	 *
	 * @return the UUID of this service
	 */
	public BluetoothUuid getUuid() {
		throw new RuntimeException();
	}

	/**
	 * Returns the number of characteristics in this service.
	 *
	 * @return the number of characteristics in this service.
	 */
	public int getNumCharacteristics() {
		throw new RuntimeException();
	}

	/**
	 * Returns the characteristic at the given index in this service.
	 *
	 * @param index
	 *            the index of the characteristic.
	 * @return the characteristic at the given index.
	 * @throws IndexOutOfBoundsException
	 *             if the index is out of range ({@code index < 0 || index >= getNumCharacteristics()}).
	 */
	public BluetoothCharacteristic getCharacteristic(int index) {
		throw new RuntimeException();
	}

	/**
	 * Sets the listener which will receive the events related to this remote service.
	 * <p>
	 * Only one listener may be set at the same time. If the remote listener has not been set, the
	 * {@link ej.bluetooth.listeners.impl.DefaultRemoteServiceListener} will be used to handle the events.
	 *
	 * @param remoteListener
	 *            the object which will receive the events.
	 * @throws IllegalStateException
	 *             if this service is not a remote service.
	 */
	public void setRemoteListener(RemoteServiceListener remoteListener) {
		throw new RuntimeException();
	}

	/**
	 * Sets the listener which will receive the events related to this local service.
	 * <p>
	 * Only one listener may be set at the same time. If the local listener has not been set, the
	 * {@link ej.bluetooth.listeners.impl.DefaultLocalServiceListener} will be used to handle the events.
	 *
	 * @param localListener
	 *            the object which will receive the events.
	 * @throws IllegalStateException
	 *             if this service is not a local service.
	 */
	public void setLocalListener(LocalServiceListener localListener) {
		throw new RuntimeException();
	}
}
