/*
 * Copyright (c) 1997, 2012, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2017, IS2T - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package javax.net.ssl;

import javax.net.ServerSocketFactory;

/**
 * <code>SSLServerSocketFactory</code>s create
 * <code>SSLServerSocket</code>s.
 *
 * @since 1.4
 * @see SSLSocket
 * @see SSLServerSocket
 * @author David Brownell
 */
public abstract class SSLServerSocketFactory extends ServerSocketFactory
{

	/**
	 * Constructor is used only by subclasses.
	 */
	protected SSLServerSocketFactory() { /* NOTHING */ }

	/**
	 * Returns the default SSL server socket factory.
	 *
	 * <p>The first time this method is called, the security property
	 * "ssl.ServerSocketFactory.provider" is examined. If it is non-null, a
	 * class by that name is loaded and instantiated. If that is successful and
	 * the object is an instance of SSLServerSocketFactory, it is made the
	 * default SSL server socket factory.
	 *
	 * <p>Otherwise, this method returns
	 * <code>SSLContext.getDefault().getServerSocketFactory()</code>. If that
	 * call fails, an inoperative factory is returned.
	 *
	 * @return the default <code>ServerSocketFactory</code>
	 * @see SSLContext#getDefault
	 */
	public static synchronized ServerSocketFactory getDefault() {
		throw new RuntimeException();
	}

}