/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth.callbacks.impl;

import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.BluetoothStatus;
import ej.bluetooth.callbacks.ServerCallbacks;

/**
 * The <code>DefaultServerCallbacks</code> class provides a default implementation of the {@link ServerCallbacks}
 * interface.
 * <p>
 * The implementation of the {@link #onNotificationSent onNotificationSent()} method does nothing. The implementation of
 * each of the other methods sends a response with status {@link BluetoothStatus#REQUEST_NOT_SUPPORTED
 * REQUEST_NOT_SUPPORTED}.
 */
public class DefaultServerCallbacks implements ServerCallbacks {

	@Override
	public void onReadRequest(BluetoothCharacteristic characteristic, BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteRequest(BluetoothCharacteristic characteristic, BluetoothDevice device, byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onNotificationSent(BluetoothCharacteristic characteristic, BluetoothDevice device, boolean success) {
		throw new RuntimeException();
	}

	@Override
	public void onReadRequest(BluetoothDescriptor descriptor, BluetoothDevice device) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteRequest(BluetoothDescriptor descriptor, BluetoothDevice device, byte[] value) {
		throw new RuntimeException();
	}
}
