/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.synchronous;

import java.io.IOException;

import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;

public interface Endpoint {

	/**
	 * Gets the name of the endpoint corresponding to the command it responds.
	 *
	 * @return the name of the endpoint.
	 */
	String getName();

	void readRequestBody(CommandReader commandReader) throws IOException;

	void writeResponseBody(CommandSender commandSender) throws IOException;

}