/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.io.IOException;
import java.util.List;

/**
 *
 */
public interface ParametersHelper {

	/**
	 * Reads the parameters of a command.
	 * <p>
	 * Method {@link CommandReader#skipParameters()} must be called after to be ready to read the following command.
	 * 
	 * @return list of the parameters.
	 */
	List<Object> readParameters(CommandReader commandReader) throws IOException;

	/**
	 * Sends the given parameters.
	 * 
	 * @param params
	 *            list of parameters to send.
	 */
	void sendParams(CommandSender commandSender, List<Object> params);

}
