/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.led;

/**
 * This class is used to manage all LEDs available on the platform. The available number of LEDs is known thanks to the
 * method {@link #getNumberOfLeds()}. A LED is identified by to its id. The range of the ids is from <code>0</code> to
 * <code>getNumberOfLeds()-1</code>.
 */
public class Leds {

	/**
	 * Intensity value to turn off a LED.
	 */
	public static final int MIN_INTENSITY = 0;

	/**
	 * Maximum intensity that a LED can handle. If a LED does not handle intensity, any valid intensity different from
	 * {@link #MIN_INTENSITY} turns the LED on.
	 */
	public static final int MAX_INTENSITY = 255;

	/**
	 * Forbidden constructor: cannot instantiate a Leds object.
	 */
	private Leds() {
	}

	/**
	 * Returns the available number of LEDs. The range of valid led ids is [0..Leds.getNumberOfLeds()-1].
	 *
	 * @return the number of leds
	 */
	public static int getNumberOfLeds() {
		throw new RuntimeException();
	}

	/**
	 * Controls the intensity of the specified LED. If the id is invalid (out of range) the method has no effect.
	 *
	 * @param ledId
	 *            the led identifier
	 * @param intensity
	 *            the intensity to set on the led
	 */
	public static void setLedIntensity(int ledId, int intensity) {
		throw new RuntimeException();
	}

	/**
	 * Gets the intensity of the specified LED. If the id is invalid (out of range) the method returns 0.
	 *
	 * @param ledId
	 *            the led identifier
	 * @return the led intensity
	 */
	public static int getLedIntensity(int ledId) {
		throw new RuntimeException();
	}

	/**
	 * Turns on the given LED. The effect is identical to <code>Leds.setLedIntensity(ledId, MAX_INTENSITY)</code>.
	 *
	 * @param ledId
	 *            the led identifier
	 */
	public static void setLedOn(int ledId) {
		throw new RuntimeException();
	}

	/**
	 * Turns off the given LED. The effect is identical to <code>Leds.setLedIntensity(ledId, MIN_INTENSITY)</code>.
	 *
	 * @param ledId
	 *            the led identifier
	 */
	public static void setLedOff(int ledId) {
		throw new RuntimeException();
	}

}
